/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.impl;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.N1qlQueryRow;
import java.util.ArrayList;
import java.util.List;
import org.gluu.persist.couchbase.impl.CouchbaseEntryManager;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.reflect.property.PropertyAnnotation;

public class CouchbaseBatchOperationWraper<T> {
    private CouchbaseEntryManager couchbaseEntryManager;
    private Class<T> entryClass;
    private List<PropertyAnnotation> propertiesAnnotations;
    private BatchOperation<T> batchOperation;

    public CouchbaseBatchOperationWraper(BatchOperation<T> batchOperation) {
        this.batchOperation = batchOperation;
    }

    public CouchbaseBatchOperationWraper(BatchOperation<T> batchOperation, CouchbaseEntryManager couchbaseEntryManager, Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations) {
        this.batchOperation = batchOperation;
        this.couchbaseEntryManager = couchbaseEntryManager;
        this.entryClass = entryClass;
        this.propertiesAnnotations = propertiesAnnotations;
    }

    public final BatchOperation<T> getBatchOperation() {
        return this.batchOperation;
    }

    public List<T> createEntities(List<N1qlQueryRow> searchResult) {
        if (this.couchbaseEntryManager == null) {
            return new ArrayList(0);
        }
        JsonObject[] resultObjects = new JsonObject[searchResult.size()];
        int index = 0;
        for (N1qlQueryRow row : searchResult) {
            resultObjects[index++] = row.value();
        }
        return this.couchbaseEntryManager.createEntities(this.entryClass, this.propertiesAnnotations, null, resultObjects);
    }
}

