/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.operation.auth;

public enum PasswordEncryptionMethod {
    HASH_METHOD_SHA("SHA", "SHA", "sha", 20),
    HASH_METHOD_SSHA("SSHA", "SHA", "ssha", 20),
    HASH_METHOD_SHA256("SHA-256", "SHA-256", "sha256", 32),
    HASH_METHOD_SSHA256("SSHA-256", "SHA-256", "ssha256", 32),
    HASH_METHOD_SHA384("SHA-384", "SHA-384", "sha384", 48),
    HASH_METHOD_SSHA384("SSHA-384", "SHA-384", "ssha384", 48),
    HASH_METHOD_SHA512("SHA-512", "SHA-512", "sha512", 64),
    HASH_METHOD_SSHA512("SSHA-512", "SHA-512", "ssha512", 64),
    HASH_METHOD_MD5("MD5", "MD5", "md5", 16),
    HASH_METHOD_SMD5("SMD5", "MD5", "smd5", 16),
    HASH_METHOD_CRYPT("CRYPT", "CRYPT", "crypt", 11),
    HASH_METHOD_CRYPT_MD5("CRYPT-MD5", "MD5", "crypt", "$1$", 22),
    HASH_METHOD_CRYPT_SHA256("CRYPT-SHA-256", "SHA-256", "crypt", "$5$", 43),
    HASH_METHOD_CRYPT_SHA512("CRYPT-SHA-512", "SHA-512", "crypt", "$6$", 86),
    HASH_METHOD_CRYPT_BCRYPT("CRYPT-BCRYPT", "BCRYPT", "crypt", "$2a$", 31),
    HASH_METHOD_CRYPT_BCRYPT_B("CRYPT-BCRYPT", "BCRYPT", "bcrypt", "$2b$", 31),
    HASH_METHOD_PKCS5S2("PKCS5S2", "PBKDF2WithHmacSHA1", "PKCS5S2", 32);

    private final String name;
    private final String algorithm;
    private final String prefix;
    private final String subPrefix;
    private final int hashLength;

    private PasswordEncryptionMethod(String name, String algorithm, String prefix, int hashLength) {
        this(name, algorithm, prefix, "", hashLength);
    }

    private PasswordEncryptionMethod(String name, String algorithm, String prefix, String subPrefix, int hashLength) {
        this.name = name;
        this.algorithm = algorithm;
        this.prefix = prefix;
        this.subPrefix = subPrefix;
        this.hashLength = hashLength;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSubPrefix() {
        return this.subPrefix;
    }

    public final int getHashLength() {
        return this.hashLength;
    }

    public static PasswordEncryptionMethod getMethod(String algorithm) {
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SHA)) {
            return HASH_METHOD_SHA;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SSHA)) {
            return HASH_METHOD_SSHA;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_MD5)) {
            return HASH_METHOD_MD5;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SMD5)) {
            return HASH_METHOD_SMD5;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_CRYPT)) {
            return HASH_METHOD_CRYPT;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_CRYPT_MD5)) {
            return HASH_METHOD_CRYPT_MD5;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_CRYPT_SHA256)) {
            return HASH_METHOD_CRYPT_SHA256;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_CRYPT_SHA512)) {
            return HASH_METHOD_CRYPT_SHA512;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_CRYPT_BCRYPT)) {
            return HASH_METHOD_CRYPT_BCRYPT;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_CRYPT_BCRYPT_B)) {
            return HASH_METHOD_CRYPT_BCRYPT_B;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SHA256)) {
            return HASH_METHOD_SHA256;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SSHA256)) {
            return HASH_METHOD_SSHA256;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SHA384)) {
            return HASH_METHOD_SHA384;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SSHA384)) {
            return HASH_METHOD_SSHA384;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SHA512)) {
            return HASH_METHOD_SHA512;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_SSHA512)) {
            return HASH_METHOD_SSHA512;
        }
        if (PasswordEncryptionMethod.matches(algorithm, HASH_METHOD_PKCS5S2)) {
            return HASH_METHOD_PKCS5S2;
        }
        return null;
    }

    private static boolean matches(String algorithm, PasswordEncryptionMethod constant) {
        return constant.name.equalsIgnoreCase(algorithm) || (constant.prefix + constant.subPrefix).equalsIgnoreCase(algorithm);
    }
}

