/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.model;

import java.util.Arrays;
import org.gluu.util.StringHelper;

public class AttributeData {
    private final String name;
    private final Object[] values;
    private Boolean multiValued;

    public AttributeData(String name, Object[] values) {
        this(name, values, null);
    }

    public AttributeData(String name, Object[] values, Boolean multiValued) {
        this.name = name;
        this.values = values;
        this.multiValued = multiValued;
    }

    public AttributeData(String name, Object value) {
        this.name = name;
        this.values = new Object[1];
        this.values[0] = value;
        this.multiValued = null;
    }

    public final String getName() {
        return this.name;
    }

    public final Object[] getValues() {
        return this.values;
    }

    public final String[] getStringValues() {
        return StringHelper.toStringArray((Object[])this.values);
    }

    public Object getValue() {
        if (this.values == null || this.values.length == 0) {
            return null;
        }
        return this.values[0];
    }

    public void setMultiValued(Boolean multiValued) {
        this.multiValued = multiValued;
    }

    public Boolean getMultiValued() {
        return this.multiValued;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.multiValued == null ? 0 : this.multiValued.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.deepHashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AttributeData other = (AttributeData)obj;
        if (this.multiValued != null && other.multiValued != null && !this.multiValued.equals(other.multiValued)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.values == null && other.values == null) {
            return true;
        }
        if (this.values == null || other.values == null || this.values.length != other.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (StringHelper.equals((String)String.valueOf(this.values[i]), (String)String.valueOf(other.values[i]))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "AttributeData [name=" + this.name + ", values=" + Arrays.toString(this.values) + ", multiValued=" + this.multiValued + "]";
    }
}

