/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.key.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.AttributesList;
import org.gluu.persist.key.impl.KeyShortcuterConf;
import org.gluu.persist.reflect.property.PropertyAnnotation;
import org.gluu.persist.reflect.util.ReflectHelper;
import org.gluu.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyShortcuter {
    private static final Logger LOG = LoggerFactory.getLogger(KeyShortcuter.class);
    public static final String CONF_FILE_NAME = "key-shortcuter-rules.json";
    private static final List<Class> PROCESSED_ENTRIES = Lists.newArrayList();
    private static final BiMap<String, String> MAP = HashBiMap.create();
    private static final BiMap<String, String> INVERSE_MAP = MAP.inverse();
    private static KeyShortcuterConf conf = KeyShortcuter.load();

    private KeyShortcuter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyShortcuterConf load() {
        try (InputStream is = KeyShortcuter.class.getResourceAsStream("/key-shortcuter-rules.json");){
            KeyShortcuterConf keyShortcuterConf = (KeyShortcuterConf)Util.createJsonMapper().readValue(is, KeyShortcuterConf.class);
            return keyShortcuterConf;
        }
        catch (IOException e) {
            LOG.error("Failed to load key shortcuter configuration from file: key-shortcuter-rules.json", (Throwable)e);
            return null;
        }
    }

    public static String fromShortcut(String shortcut) {
        return (String)INVERSE_MAP.getOrDefault((Object)shortcut, (Object)shortcut);
    }

    public static String shortcut(String key) {
        if (conf == null) {
            LOG.error("Failed to load key shortcuter configuration from file: key-shortcuter-rules.json");
            return key;
        }
        if (StringUtils.isBlank((String)key)) {
            return key;
        }
        String cachedShortcut = (String)MAP.get((Object)key);
        if (cachedShortcut != null) {
            return cachedShortcut;
        }
        String copy = key;
        String exclusion = conf.getExclusions().get(key);
        if (StringUtils.isNotBlank((String)exclusion)) {
            MAP.put((Object)copy, (Object)exclusion);
            return exclusion;
        }
        for (String string : conf.getPrefixes()) {
            if (!key.startsWith(string)) continue;
            key = StringUtils.removeStart((String)key, (String)string);
        }
        for (Map.Entry entry : conf.getReplaces().entrySet()) {
            key = StringUtils.replace((String)key, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        key = KeyShortcuter.lowercaseFirstChar(key);
        try {
            MAP.put((Object)copy, (Object)key);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Found duplicate for key: " + key + ", duplicate from: " + (String)MAP.inverse().get((Object)key));
            return copy;
        }
        return key;
    }

    public static String lowercaseFirstChar(String key) {
        return Character.toLowerCase(key.charAt(0)) + key.substring(1);
    }

    public static <T> void initIfNeeded(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations) {
        if (entryClass == null || propertiesAnnotations == null || PROCESSED_ENTRIES.contains(entryClass)) {
            return;
        }
        for (PropertyAnnotation propertiesAnnotation : propertiesAnnotations) {
            Annotation annotation = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributeName.class);
            if (annotation != null) {
                KeyShortcuter.shortcut(((AttributeName)annotation).name());
                continue;
            }
            annotation = ReflectHelper.getAnnotationByType(propertiesAnnotation.getAnnotations(), AttributesList.class);
            if (annotation == null) continue;
            for (AttributeName attributeConfiguration : ((AttributesList)annotation).attributesConfiguration()) {
                KeyShortcuter.shortcut(attributeConfiguration.name());
            }
        }
        PROCESSED_ENTRIES.add(entryClass);
    }
}

