/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.key.impl;

import org.gluu.persist.exception.KeyConversionException;
import org.gluu.persist.key.impl.model.ParsedKey;
import org.gluu.util.StringHelper;

public class GenericKeyConverter {
    public ParsedKey convertToKey(String dn) {
        if (StringHelper.isEmpty((String)dn)) {
            throw new KeyConversionException("Failed to convert empty DN to Key");
        }
        StringBuilder result = new StringBuilder();
        String[] tokens = dn.split(",");
        String orgInum = null;
        String attributeName = null;
        for (String token : tokens) {
            int pos = token.indexOf("=");
            if (pos == -1) {
                throw new KeyConversionException("Failed to convert empty DN to Key");
            }
            String name = token.substring(0, pos);
            if (attributeName == null) {
                attributeName = name;
            }
            String value = token.substring(pos + 1, token.length());
            if (StringHelper.equalsIgnoreCase((String)name, (String)"o")) {
                if (StringHelper.equalsIgnoreCase((String)value, (String)"gluu")) continue;
                orgInum = value;
                continue;
            }
            result.insert(0, "_" + value);
        }
        String key = result.toString();
        key = key.length() == 0 ? "_" : key.substring(1);
        return new ParsedKey(key, attributeName, orgInum);
    }
}

