/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model.attribute;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.gluu.model.GluuStatus;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.model.attribute.AttributeUsageType;
import org.gluu.model.attribute.AttributeValidation;
import org.gluu.model.user.UserRole;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.Entry;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="Attribute")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Attribute
extends Entry
implements Serializable {
    private static final long serialVersionUID = 4817004894646725606L;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @AttributeName(name="oxAttributeType")
    private String type;
    @AttributeName
    private String lifetime;
    @AttributeName(name="oxSourceAttribute")
    private String sourceAttribute;
    @AttributeName
    private String salt;
    @AttributeName(name="oxNameIdType")
    private String nameIdType;
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9]+$", message="Name should contain alphabetical and numeric characters only")
    @Size(min=1, max=30, message="Length of the Name should be between 1 and 30")
    @AttributeName(name="gluuAttributeName")
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9]+$", message="Name should contain alphabetical and numeric characters only") @Size(min=1, max=30, message="Length of the Name should be between 1 and 30") String name;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    private @NotNull @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @AttributeName(name="gluuAttributeOrigin")
    private String origin;
    @NotNull
    @AttributeName(name="gluuAttributeType")
    private AttributeDataType dataType;
    @NotNull
    @AttributeName(name="gluuAttributeEditType")
    private UserRole[] editType;
    @NotNull
    @AttributeName(name="gluuAttributeViewType")
    private UserRole[] viewType;
    @AttributeName(name="gluuAttributeUsageType")
    private AttributeUsageType[] usageType;
    @AttributeName(name="oxAuthClaimName")
    private String oxAuthClaimName;
    @AttributeName(name="seeAlso")
    private String seeAlso;
    @AttributeName(name="gluuStatus")
    private GluuStatus status;
    @AttributeName(name="gluuSAML1URI")
    private String saml1Uri;
    @AttributeName(name="gluuSAML2URI")
    private String saml2Uri;
    @AttributeName(ignoreDuringUpdate=true)
    private String urn;
    @AttributeName(name="oxSCIMCustomAttribute")
    private Boolean oxSCIMCustomAttribute;
    @AttributeName(name="oxMultivaluedAttribute")
    private Boolean multiValuedAttribute;
    @JsonObject
    @AttributeName(name="oxValidation")
    private AttributeValidation attributeValidation;
    @AttributeName(name="gluuTooltip")
    private String gluuTooltip;

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    public void setSourceAttribute(String sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getNameIdType() {
        return this.nameIdType;
    }

    public void setNameIdType(String nameIdType) {
        this.nameIdType = nameIdType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public AttributeDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(AttributeDataType dataType) {
        this.dataType = dataType;
    }

    public UserRole[] getEditType() {
        return this.editType;
    }

    public void setEditType(UserRole[] editType) {
        this.editType = editType;
    }

    public UserRole[] getViewType() {
        return this.viewType;
    }

    public void setViewType(UserRole[] viewType) {
        this.viewType = viewType;
    }

    public AttributeUsageType[] getUsageType() {
        return this.usageType;
    }

    public void setUsageType(AttributeUsageType[] usageType) {
        this.usageType = usageType;
    }

    public String getOxAuthClaimName() {
        return this.oxAuthClaimName;
    }

    public void setOxAuthClaimName(String oxAuthClaimName) {
        this.oxAuthClaimName = oxAuthClaimName;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public String getSaml1Uri() {
        return this.saml1Uri;
    }

    public void setSaml1Uri(String saml1Uri) {
        this.saml1Uri = saml1Uri;
    }

    public String getSaml2Uri() {
        return this.saml2Uri;
    }

    public void setSaml2Uri(String saml2Uri) {
        this.saml2Uri = saml2Uri;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public Boolean getOxSCIMCustomAttribute() {
        return this.oxSCIMCustomAttribute;
    }

    public void setOxSCIMCustomAttribute(Boolean oxSCIMCustomAttribute) {
        this.oxSCIMCustomAttribute = oxSCIMCustomAttribute;
    }

    public Boolean getMultiValuedAttribute() {
        return this.multiValuedAttribute;
    }

    public void setMultiValuedAttribute(Boolean multivaluedAttribute) {
        this.multiValuedAttribute = multivaluedAttribute;
    }

    public String getGluuTooltip() {
        return this.gluuTooltip;
    }

    public void setGluuTooltip(String gluuTooltip) {
        this.gluuTooltip = gluuTooltip;
    }

    public AttributeValidation getAttributeValidation() {
        return this.attributeValidation;
    }

    public void setAttributeValidation(AttributeValidation attributeValidation) {
        this.attributeValidation = attributeValidation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.editType);
        result = 31 * result + (this.gluuTooltip == null ? 0 : this.gluuTooltip.hashCode());
        result = 31 * result + (this.inum == null ? 0 : this.inum.hashCode());
        result = 31 * result + (this.lifetime == null ? 0 : this.lifetime.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nameIdType == null ? 0 : this.nameIdType.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.oxAuthClaimName == null ? 0 : this.oxAuthClaimName.hashCode());
        result = 31 * result + (this.multiValuedAttribute == null ? 0 : this.multiValuedAttribute.hashCode());
        result = 31 * result + (this.oxSCIMCustomAttribute == null ? 0 : this.oxSCIMCustomAttribute.hashCode());
        result = 31 * result + (this.salt == null ? 0 : this.salt.hashCode());
        result = 31 * result + (this.saml1Uri == null ? 0 : this.saml1Uri.hashCode());
        result = 31 * result + (this.saml2Uri == null ? 0 : this.saml2Uri.hashCode());
        result = 31 * result + (this.seeAlso == null ? 0 : this.seeAlso.hashCode());
        result = 31 * result + (this.sourceAttribute == null ? 0 : this.sourceAttribute.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.urn == null ? 0 : this.urn.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.usageType);
        result = 31 * result + Arrays.hashCode((Object[])this.viewType);
        return result;
    }
}

