/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.ldap.impl;

import com.unboundid.ldap.sdk.LDAPException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.search.filter.Filter;
import org.gluu.search.filter.FilterType;

public class LdapFilterConverter {
    public com.unboundid.ldap.sdk.Filter convertToLdapFilter(Filter genericFilter) throws SearchException {
        FilterType type = genericFilter.getType();
        if (FilterType.RAW == type) {
            try {
                return com.unboundid.ldap.sdk.Filter.create((String)genericFilter.getFilterString());
            }
            catch (LDAPException ex) {
                throw new SearchException("Failed to parse RAW Ldap filter", (Throwable)ex, ex.getResultCode().intValue());
            }
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = genericFilter.getFilters();
            com.unboundid.ldap.sdk.Filter[] ldapFilters = new com.unboundid.ldap.sdk.Filter[genericFilters.length];
            if (genericFilters != null) {
                for (int i = 0; i < genericFilters.length; ++i) {
                    ldapFilters[i] = this.convertToLdapFilter(genericFilters[i]);
                }
                if (FilterType.NOT == type) {
                    return com.unboundid.ldap.sdk.Filter.createNOTFilter((com.unboundid.ldap.sdk.Filter)ldapFilters[0]);
                }
                if (FilterType.AND == type) {
                    return com.unboundid.ldap.sdk.Filter.createANDFilter((com.unboundid.ldap.sdk.Filter[])ldapFilters);
                }
                if (FilterType.OR == type) {
                    return com.unboundid.ldap.sdk.Filter.createORFilter((com.unboundid.ldap.sdk.Filter[])ldapFilters);
                }
            }
        }
        if (FilterType.EQUALITY == type) {
            return com.unboundid.ldap.sdk.Filter.createEqualityFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getAssertionValue());
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            return com.unboundid.ldap.sdk.Filter.createLessOrEqualFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getAssertionValue());
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            return com.unboundid.ldap.sdk.Filter.createGreaterOrEqualFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getAssertionValue());
        }
        if (FilterType.PRESENCE == type) {
            return com.unboundid.ldap.sdk.Filter.createPresenceFilter((String)genericFilter.getAttributeName());
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            return com.unboundid.ldap.sdk.Filter.createApproximateMatchFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getAssertionValue());
        }
        if (FilterType.SUBSTRING == type) {
            return com.unboundid.ldap.sdk.Filter.createSubstringFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getSubInitial(), (String[])genericFilter.getSubAny(), (String)genericFilter.getSubFinal());
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type), 2);
    }
}

