/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.ldap.impl;

import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.gluu.persist.ldap.impl.LdapEntryManager;
import org.gluu.persist.ldap.operation.impl.LdapAuthConnectionProvider;
import org.gluu.persist.ldap.operation.impl.LdapConnectionProvider;
import org.gluu.persist.ldap.operation.impl.LdapOperationsServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LdapEntryManagerFactory
implements PersistenceEntryManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapEntryManager.class);

    public String getPersistenceType() {
        return "ldap";
    }

    public String getDefaultConfigurationFileName() {
        return "ox-ldap.properties";
    }

    public LdapEntryManager createEntryManager(Properties conf) {
        LdapConnectionProvider connectionProvider = new LdapConnectionProvider(conf);
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create LDAP connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        LdapAuthConnectionProvider bindConnectionProvider = new LdapAuthConnectionProvider(conf);
        if (!bindConnectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create LDAP bind connection pool! Result code: '%s'", bindConnectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created bindConnectionProvider '{}' with code '{}'", (Object)bindConnectionProvider, (Object)bindConnectionProvider.getCreationResultCode());
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new LdapOperationsServiceImpl(connectionProvider, bindConnectionProvider));
        LOG.info("Created LdapEntryManager: {}", (Object)ldapEntryManager.getOperationService());
        return ldapEntryManager;
    }
}

