/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.jsf2.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import org.gluu.model.GluuAttribute;
import org.gluu.model.attribute.AttributeValidation;
import org.gluu.util.StringHelper;

@FacesValidator(value="attributeValidator")
public class AttributeValidator
implements Validator {
    public void validate(FacesContext context, UIComponent comp, Object value) {
        FacesMessage message;
        GluuAttribute attribute = (GluuAttribute)comp.getAttributes().get("attribute");
        if (attribute == null) {
            ((UIInput)comp).setValid(true);
            return;
        }
        AttributeValidation attributeValidation = attribute.getAttributeValidation();
        Integer minvalue = attributeValidation != null ? attributeValidation.getMinLength() : null;
        Integer maxValue = attributeValidation != null ? attributeValidation.getMaxLength() : null;
        String regexpValue = attributeValidation != null ? attributeValidation.getRegexp() : null;
        String attributeValue = (String)value;
        if (minvalue != null) {
            int min = attributeValidation.getMinLength();
            if (attributeValue != null && attributeValue.length() < min) {
                ((UIInput)comp).setValid(false);
                message = new FacesMessage(attribute.getDisplayName() + " should be at least " + min + " symbols. ");
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(comp.getClientId(context), message);
            }
        }
        int max = 400;
        if (maxValue != null) {
            max = attributeValidation.getMaxLength();
        }
        if (attributeValue != null && attributeValue.length() > max) {
            ((UIInput)comp).setValid(false);
            message = new FacesMessage(attribute.getDisplayName() + " should not exceed " + max + " symbols. ");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(comp.getClientId(context), message);
        }
        if (attribute.getName().equalsIgnoreCase("mail") && (regexpValue == null || StringHelper.isEmpty((String)regexpValue))) {
            regexpValue = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$";
        }
        if (regexpValue != null && StringHelper.isNotEmpty((String)regexpValue)) {
            Matcher matcher;
            boolean flag;
            Pattern pattern = Pattern.compile(regexpValue);
            if (attributeValue != null && !attributeValue.trim().equals("") && !(flag = (matcher = pattern.matcher(attributeValue)).matches())) {
                ((UIInput)comp).setValid(false);
                FacesMessage message2 = new FacesMessage(attribute.getDisplayName() + " Format is invalid. ");
                message2.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(comp.getClientId(context), message2);
            }
        }
    }
}

