/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.el;

import com.sun.el.lang.FunctionMapperImpl;
import com.sun.el.lang.VariableMapperImpl;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.VariableMapper;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.gluu.service.el.ConstantResolver;
import org.gluu.service.el.ExtendedELContext;

@Dependent
public class ContextProducer {
    @Inject
    private BeanManager beanManager;

    @Produces
    @RequestScoped
    public ExtendedELContext createELContext() {
        ConstantResolver constantResolver = new ConstantResolver();
        CompositeELResolver resolver = this.createELResolver(constantResolver);
        return this.createELContext((ELResolver)resolver, (FunctionMapper)new FunctionMapperImpl(), (VariableMapper)new VariableMapperImpl(), constantResolver);
    }

    private CompositeELResolver createELResolver(ConstantResolver constantResolver) {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)constantResolver);
        resolver.add(this.beanManager.getELResolver());
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            resolver.add(facesContext.getELContext().getELResolver());
        }
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        return resolver;
    }

    private ExtendedELContext createELContext(final ELResolver resolver, final FunctionMapper functionMapper, final VariableMapper variableMapper, final ConstantResolver constantResolver) {
        return new ExtendedELContext(){

            public ELResolver getELResolver() {
                return resolver;
            }

            public FunctionMapper getFunctionMapper() {
                return functionMapper;
            }

            public VariableMapper getVariableMapper() {
                return variableMapper;
            }

            @Override
            public ConstantResolver getConstantResolver() {
                return constantResolver;
            }
        };
    }
}

