/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.jsf2.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gluu.util.StringHelper;
import org.gluu.util.io.DownloadWrapper;
import org.gluu.util.io.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseHelper {
    private static Logger LOG = LoggerFactory.getLogger(ResponseHelper.class);

    private ResponseHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String filePath, String contentType, FacesContext facesContext) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            LOG.error(String.format("Failed to send file %s. File doesn't exist.", file.getAbsolutePath()));
            return true;
        }
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        FileInputStream is = null;
        try {
            is = FileUtils.openInputStream((File)file);
            DownloadWrapper downloadWrapper = new DownloadWrapper((InputStream)is, file.getName(), contentType, new Date(file.lastModified()), (int)file.length());
            FileDownloader.writeOutput((DownloadWrapper)downloadWrapper, (boolean)false, (HttpServletResponse)response);
            facesContext.responseComplete();
        }
        catch (Exception ex) {
            LOG.error(String.format("Failed to send file %s", file.getAbsolutePath()), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return true;
    }

    public static boolean downloadFile(String fileName, String contentType, byte[] file, FacesContext facesContext) {
        return ResponseHelper.downloadFile(fileName, contentType, file, FileDownloader.ContentDisposition.ATTACHEMENT, facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String fileName, String contentType, byte[] file, FileDownloader.ContentDisposition contentDisposition, FacesContext facesContext) {
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(file);
            DownloadWrapper downloadWrapper = new DownloadWrapper((InputStream)is, fileName, contentType, new Date(), file.length);
            FileDownloader.writeOutput((DownloadWrapper)downloadWrapper, (FileDownloader.ContentDisposition)contentDisposition, (HttpServletResponse)response);
            facesContext.responseComplete();
        }
        catch (Exception ex) {
            boolean bl;
            try {
                LOG.error("Failed to send file", (Throwable)ex);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return bl;
        }
        IOUtils.closeQuietly((InputStream)is);
        return true;
    }

    public static ZipOutputStream createZipStream(OutputStream output, String comment) {
        ZipOutputStream zos = new ZipOutputStream(output);
        zos.setComment("Shibboleth2 SP configuration files");
        zos.setMethod(8);
        zos.setLevel(-1);
        return zos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToZip(String filePath, ZipOutputStream zos, String fileName) {
        if (StringHelper.isEmpty((String)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            LOG.error(String.format("Failed to add file %s to zip archive", file.getName()));
            return false;
        }
        boolean result = false;
        FileInputStream is = null;
        try {
            is = FileUtils.openInputStream((File)file);
            String zipFileName = fileName == null ? file.getName() : fileName;
            result = ResponseHelper.addInputStream(zos, zipFileName, is);
        }
        catch (IOException ex) {
            LOG.error(String.format("Failed to add file %s to zip archive", file.getName()), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileContentToZip(String fileContent, ZipOutputStream zos, String fileName) {
        if (StringHelper.isEmpty((String)fileContent) || StringHelper.isEmpty((String)fileName)) {
            return false;
        }
        boolean result = false;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
            result = ResponseHelper.addInputStream(zos, fileName, is);
        }
        catch (IOException ex) {
            try {
                LOG.error(String.format("Failed to add file %s to zip archive", fileName), (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addResourceToZip(InputStream is, String fileName, ZipOutputStream zos) {
        boolean result = false;
        try {
            result = ResponseHelper.addInputStream(zos, fileName, is);
        }
        catch (Exception ex) {
            LOG.error(String.format("Failed to add resource %s to zip archive", fileName), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return result;
    }

    private static boolean addInputStream(ZipOutputStream zos, String fileName, InputStream is) {
        try {
            ZipEntry configurationFileEntry = new ZipEntry(fileName);
            zos.putNextEntry(configurationFileEntry);
            IOUtils.copy((InputStream)is, (OutputStream)zos);
        }
        catch (IOException ex) {
            LOG.error(String.format("Failed to add file %s to zip archive", fileName), (Throwable)ex);
            return false;
        }
        return true;
    }
}

