/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.jsf2.converter;

import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.apache.commons.lang.time.DateUtils;

@FacesConverter(value="uptimeConverter")
public class UptimeConverter
implements Converter {
    private static final String[] dateFormats = new String[]{"D 'd' HH 'h' mm 'm' ss 's'"};

    public Object getAsObject(FacesContext context, UIComponent comp, String value) throws ConverterException {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)value, (String[])dateFormats);
        }
        catch (ParseException e) {
            throw new ConverterException("Unable to convert " + value + " to seconds!");
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object object) throws ConverterException {
        if (object instanceof String) {
            try {
                return this.getSecondsAsString(Long.valueOf((String)object));
            }
            catch (NumberFormatException ex) {
                throw new ConverterException("Unable to convert " + object + " to date!");
            }
        }
        return null;
    }

    private String getSecondsAsString(long seconds) {
        int days = (int)TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds) - (long)(days * 24);
        long mins = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long secondsInMinute = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        return days + " d " + hours + " h " + mins + " m " + secondsInMinute + " s";
    }
}

