/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.jsf2.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.FacesComponent;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.gluu.jsf2.component.ValueExpressionAnalyzer;
import org.gluu.util.StringHelper;

@FacesComponent(value="org.gluu.oxtrust.util.jsf.InputContainer")
public class UIInputContainer
extends UIComponentBase
implements NamingContainer {
    public static final String COMPONENT_TYPE = "org.gluu.oxtrust.util.jsf.InputContainer";
    protected static final String HTML_ID_ATTR_NAME = "id";
    protected static final String HTML_CLASS_ATTR_NAME = "class";
    protected static final String HTML_STYLE_ATTR_NAME = "style";
    private boolean beanValidationPresent = this.isClassPresent("javax.validation.Validator");

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public String getInvalidAttributeName() {
        return "invalid";
    }

    public String getRequiredAttributeName() {
        return "required";
    }

    public String getLabelAttributeName() {
        return "label";
    }

    public String getElementsAttributeName() {
        return "elements";
    }

    public String getEncloseAttributeName() {
        return "enclose";
    }

    public String getContainerElementName() {
        return "div";
    }

    public String getDefaultLabelId() {
        return "label";
    }

    public String getDefaultInputId() {
        return "input";
    }

    public String getDefaultMessageId() {
        return "message";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String label;
        if (!this.isRendered()) {
            return;
        }
        super.encodeBegin(context);
        InputContainerElements elements = this.scan(this.getFacet("javax.faces.component.COMPOSITE_FACET_NAME"), null, context);
        this.wire(elements, context);
        this.getAttributes().put(this.getElementsAttributeName(), elements);
        if (elements.hasValidationError()) {
            this.getAttributes().put(this.getInvalidAttributeName(), true);
        }
        this.getAttributes().put(this.getRequiredAttributeName(), elements.hasRequiredInput());
        if (this.getValueExpression(this.getLabelAttributeName()) == null && (!this.getAttributes().containsKey(this.getLabelAttributeName()) || this.labelHasEmptyValue(elements)) && (label = this.generateLabel(elements, context)) != null) {
            this.getAttributes().put(this.getLabelAttributeName(), label);
        }
        if (Boolean.TRUE.equals(this.getAttributes().get(this.getEncloseAttributeName()))) {
            this.startContainerElement(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        super.encodeEnd(context);
        if (Boolean.TRUE.equals(this.getAttributes().get(this.getEncloseAttributeName()))) {
            this.endContainerElement(context);
        }
    }

    protected void startContainerElement(FacesContext context) throws IOException {
        String styleClass;
        String style;
        context.getResponseWriter().startElement(this.getContainerElementName(), (UIComponent)this);
        String string = style = this.getAttributes().get(HTML_STYLE_ATTR_NAME) != null ? this.getAttributes().get(HTML_STYLE_ATTR_NAME).toString().trim() : null;
        if (style.length() > 0) {
            context.getResponseWriter().writeAttribute(HTML_STYLE_ATTR_NAME, (Object)style, HTML_STYLE_ATTR_NAME);
        }
        String string2 = styleClass = this.getAttributes().get("styleClass") != null ? this.getAttributes().get("styleClass").toString().trim() : null;
        if (styleClass.length() > 0) {
            context.getResponseWriter().writeAttribute(HTML_CLASS_ATTR_NAME, (Object)styleClass, HTML_CLASS_ATTR_NAME);
        }
        context.getResponseWriter().writeAttribute(HTML_ID_ATTR_NAME, (Object)this.getClientId(context), HTML_ID_ATTR_NAME);
    }

    protected void endContainerElement(FacesContext context) throws IOException {
        context.getResponseWriter().endElement(this.getContainerElementName());
    }

    protected String generateLabel(InputContainerElements elements, FacesContext context) {
        String name;
        String string = name = this.getId().startsWith("j_id") ? elements.getPropertyName(context) : this.getId();
        if (StringHelper.isEmpty((String)name)) {
            return null;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected InputContainerElements scan(UIComponent component, InputContainerElements elements, FacesContext context) {
        if (elements == null) {
            elements = new InputContainerElements();
        }
        if (elements.getLabel() == null && component instanceof HtmlOutputLabel) {
            elements.setLabel((HtmlOutputLabel)component);
        } else if (component instanceof EditableValueHolder) {
            elements.registerInput((EditableValueHolder)component, this.getDefaultValidator(context), context);
        } else if (component instanceof UIMessage) {
            elements.registerMessage((UIMessage)component);
        }
        for (UIComponent child : component.getChildren()) {
            this.scan(child, elements, context);
        }
        return elements;
    }

    public void assignIds(InputContainerElements elements, FacesContext context) {
        int i;
        HtmlOutputLabel label;
        boolean refreshIds = false;
        if (this.getId().startsWith("j_id")) {
            this.setId(elements.getPropertyName(context));
            refreshIds = true;
        }
        if ((label = elements.getLabel()) != null) {
            if (label.getId().startsWith("j_id")) {
                label.setId(this.getDefaultLabelId());
            } else if (refreshIds) {
                label.setId(label.getId());
            }
        }
        int len = elements.getInputs().size();
        for (i = 0; i < len; ++i) {
            UIComponent input = (UIComponent)elements.getInputs().get(i);
            if (input.getId().startsWith("j_id")) {
                input.setId(this.getDefaultInputId() + (i == 0 ? "" : Integer.valueOf(i + 1)));
                continue;
            }
            if (!refreshIds) continue;
            input.setId(input.getId());
        }
        len = elements.getMessages().size();
        for (i = 0; i < len; ++i) {
            UIComponent msg = (UIComponent)elements.getMessages().get(i);
            if (msg.getId().startsWith("j_id")) {
                msg.setId(this.getDefaultMessageId() + (i == 0 ? "" : Integer.valueOf(i + 1)));
                continue;
            }
            if (!refreshIds) continue;
            msg.setId(msg.getId());
        }
    }

    protected void wire(InputContainerElements elements, FacesContext context) {
        elements.wire(context);
    }

    private Validator getDefaultValidator(FacesContext context) throws FacesException {
        ValidatorFactory validatorFactory;
        if (!this.beanValidationPresent) {
            return null;
        }
        Object cachedObject = context.getExternalContext().getApplicationMap().get("javax.faces.validator.beanValidator.ValidatorFactory");
        if (cachedObject instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)cachedObject;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                throw new FacesException("Could not build a default Bean Validator factory", (Throwable)e);
            }
            context.getExternalContext().getApplicationMap().put("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
        }
        return validatorFactory.getValidator();
    }

    private boolean isClassPresent(String fqcn) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(fqcn) != null;
            }
            return Class.forName(fqcn) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private boolean labelHasEmptyValue(InputContainerElements elements) {
        if (elements.getLabel() == null || elements.getLabel().getValue() == null) {
            return false;
        }
        return elements.getLabel().getValue().toString().trim().equals(":") || elements.getLabel().getValue().toString().trim().equals("");
    }

    public static class InputContainerElements {
        private String propertyName;
        private HtmlOutputLabel label;
        private final List<EditableValueHolder> inputs = new ArrayList<EditableValueHolder>();
        private final List<UIMessage> messages = new ArrayList<UIMessage>();
        private boolean validationError = false;

        public HtmlOutputLabel getLabel() {
            return this.label;
        }

        public void setLabel(HtmlOutputLabel label) {
            this.label = label;
        }

        public List<EditableValueHolder> getInputs() {
            return this.inputs;
        }

        public void registerInput(EditableValueHolder input, Validator validator, FacesContext context) {
            this.inputs.add(input);
            if (!input.isValid()) {
                this.validationError = true;
            } else if (!this.validationError) {
                Iterator it = context.getMessages(((UIComponent)input).getClientId(context));
                while (it.hasNext()) {
                    if (((FacesMessage)it.next()).getSeverity().compareTo((Object)FacesMessage.SEVERITY_WARN) < 0) continue;
                    this.validationError = true;
                    break;
                }
            }
        }

        public List<UIMessage> getMessages() {
            return this.messages;
        }

        public void registerMessage(UIMessage message) {
            this.messages.add(message);
        }

        public boolean hasValidationError() {
            return this.validationError;
        }

        public boolean hasRequiredInput() {
            for (EditableValueHolder holder : this.inputs) {
                if (!holder.isRequired()) continue;
                return true;
            }
            return false;
        }

        public String getPropertyName(FacesContext context) {
            if (this.propertyName != null) {
                return this.propertyName;
            }
            if (this.inputs.size() == 0) {
                return null;
            }
            this.propertyName = (String)new ValueExpressionAnalyzer(((UIComponent)this.inputs.get(0)).getValueExpression("value")).getValueReference(context.getELContext()).getProperty();
            return this.propertyName;
        }

        public void wire(FacesContext context) {
            int numInputs = this.inputs.size();
            if (numInputs > 0) {
                if (this.label != null) {
                    this.label.setFor(((UIComponent)this.inputs.get(0)).getClientId(context));
                }
                int len = this.messages.size();
                for (int i = 0; i < len; ++i) {
                    if (i >= numInputs) continue;
                    this.messages.get(i).setFor(((UIComponent)this.inputs.get(i)).getClientId(context));
                }
            }
        }
    }
}

