/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.jsf2.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.commons.text.StringEscapeUtils;
import org.gluu.service.el.ExpressionEvaluator;

@RequestScoped
public class FacesMessages
implements Serializable {
    private static final long serialVersionUID = -6408439483194578659L;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private ExpressionEvaluator expressionEvaluator;
    private HashMap<String, FacesMessage> messages;

    @PostConstruct
    private void init() {
        this.messages = new HashMap();
    }

    public void add(FacesMessage.Severity severity, String message) {
        this.add(null, severity, message);
    }

    public void add(String clientId, FacesMessage.Severity severity, String message) {
        if (this.facesContext == null) {
            return;
        }
        String evaluatedMessage = this.evalAsString(message);
        String encodedMessage = StringEscapeUtils.escapeHtml4((String)evaluatedMessage);
        FacesMessage facesMessage = new FacesMessage(severity, encodedMessage, encodedMessage);
        this.facesContext.addMessage(clientId, facesMessage);
        this.messages.put(clientId, facesMessage);
        this.setKeepMessages();
    }

    public void add(FacesMessage.Severity severity, String message, Object ... params) {
        String fomrattedMessage = String.format(message, params);
        this.add(severity, fomrattedMessage);
        this.setKeepMessages();
    }

    public void setKeepMessages() {
        if (this.externalContext == null) {
            return;
        }
        this.externalContext.getFlash().setKeepMessages(true);
    }

    public void clear() {
        this.messages.clear();
        if (this.facesContext == null) {
            return;
        }
        Iterator messages = this.facesContext.getMessages();
        while (messages.hasNext()) {
            messages.next();
            messages.remove();
        }
    }

    public String evalAsString(String expression) {
        if (this.facesContext == null) {
            return expression;
        }
        ExpressionFactory expressionFactory = this.facesContext.getApplication().getExpressionFactory();
        ELContext elContext = this.facesContext.getELContext();
        ValueExpression valueExpression = expressionFactory.createValueExpression(elContext, expression, String.class);
        String result = (String)valueExpression.getValue(elContext);
        return result;
    }

    public String evalResourceAsString(String resource) {
        String resourceMessage = this.evalAsString(resource);
        String message = this.evalAsString(resourceMessage);
        return message;
    }

    public String evalAsString(String expression, Map<String, Object> parameters) {
        return (String)this.expressionEvaluator.evaluateValueExpression(expression, String.class, parameters);
    }

    public HashMap<String, FacesMessage> getMessages() {
        return this.messages;
    }
}

