/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.jsf2.i18n;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.faces.context.FacesContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedResourceBundle
extends ResourceBundle {
    private static final Logger LOG;
    private static final String BASE_NAME = "messages";
    private static final ResourceBundle.Control CONTROL;
    private static Path EXTERNAL_PATH;
    private static WatchKey WATCHER;
    private static Date WATCHER_LAST_UPDATE;
    private final ReentrantLock updateLock = new ReentrantLock();
    private Path externalResource;
    private Properties properties;
    private Date lastUpdate;

    public ExtendedResourceBundle() {
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        this.setParent(ResourceBundle.getBundle(this.getBaseName(), locale, CONTROL));
    }

    private ExtendedResourceBundle(Path externalResource, Properties properties) {
        this.externalResource = externalResource;
        this.properties = properties;
        this.lastUpdate = new Date();
    }

    @Override
    protected Object handleGetObject(String key) {
        if (this.properties != null) {
            if (EXTERNAL_PATH != null && WATCHER != null) {
                this.checkWatcher();
                this.updateLock.lock();
                try {
                    if (WATCHER_LAST_UPDATE.after(this.lastUpdate)) {
                        ExtendedResourceBundle.loadPropertiesFromFile(this.properties, this.externalResource);
                        this.lastUpdate = new Date();
                    }
                }
                finally {
                    this.updateLock.unlock();
                }
            }
            return this.properties.get(key);
        }
        return this.parent.getObject(key);
    }

    private void checkWatcher() {
        if (!WATCHER.pollEvents().isEmpty()) {
            WATCHER_LAST_UPDATE = new Date();
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.properties != null) {
            Set<Object> keys = this.properties.keySet();
            return Collections.enumeration(keys);
        }
        return this.parent.getKeys();
    }

    public String getBaseName() {
        return BASE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadPropertiesFromFile(Properties properties, Path externalResource) {
        if (externalResource == null) {
            return;
        }
        FileReader input = null;
        try {
            File file = externalResource.toFile();
            if (file.exists()) {
                input = new FileReader(externalResource.toFile());
                properties.load(input);
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to read properties file", (Throwable)ex);
        }
        finally {
            if (input != null) {
                IOUtils.closeQuietly(input);
            }
        }
    }

    static {
        Path customPath;
        File file;
        LOG = LoggerFactory.getLogger(ExtendedResourceBundle.class);
        CONTROL = new CustomControl();
        WATCHER = null;
        WATCHER_LAST_UPDATE = new Date();
        if (System.getProperty("server.base") != null && (file = (customPath = Paths.get(System.getProperty("server.base") + "/custom/i18n", new String[0])).toFile()).exists() && file.isDirectory()) {
            EXTERNAL_PATH = customPath;
        }
        try {
            if (EXTERNAL_PATH != null) {
                WATCHER = EXTERNAL_PATH.register(FileSystems.getDefault().newWatchService(), StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to initialize custom i18n messages watcher service");
        }
    }

    protected static class CustomControl
    extends ResourceBundle.Control {
        protected CustomControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            Properties properties = new Properties();
            InputStream input = null;
            try {
                input = loader.getResourceAsStream(resourceName);
                InputStreamReader inputReader = new InputStreamReader(input, "UTF-8");
                properties.load(inputReader);
            }
            finally {
                if (input != null) {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            Path externalResource = null;
            if (EXTERNAL_PATH != null) {
                externalResource = EXTERNAL_PATH.resolve(resourceName);
            }
            ExtendedResourceBundle.loadPropertiesFromFile(properties, externalResource);
            return new ExtendedResourceBundle(externalResource, properties);
        }
    }
}

