/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.i18n;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class ExtendedResourceBundle
extends ResourceBundle {
    private WatchKey watcher = null;
    private Date watcherLastUpdate = new Date();
    private String baseName;
    private Path externalResource;
    private Properties properties;
    private Date lastUpdate;
    private final ReentrantLock updateLock = new ReentrantLock();

    public ExtendedResourceBundle(String baseName, Path externalResource, Properties properties) throws IOException {
        this.baseName = baseName;
        this.externalResource = externalResource;
        this.properties = properties;
        this.lastUpdate = new Date();
        Path baseFolder = externalResource.getParent();
        this.watcher = baseFolder.register(FileSystems.getDefault().newWatchService(), StandardWatchEventKinds.ENTRY_MODIFY);
    }

    @Override
    protected Object handleGetObject(String key) {
        if (this.properties != null) {
            if (this.externalResource != null && this.watcher != null) {
                this.checkWatcher();
                this.updateLock.lock();
                try {
                    if (this.watcherLastUpdate.after(this.lastUpdate)) {
                        ExtendedResourceBundle.loadPropertiesFromFile(this.properties, this.externalResource);
                        this.lastUpdate = new Date();
                    }
                }
                catch (IOException ex) {
                    System.err.println("Failed to reload message bundle:" + this.externalResource);
                }
                finally {
                    this.updateLock.unlock();
                }
            }
            return this.properties.get(key);
        }
        return this.parent.getObject(key);
    }

    private void checkWatcher() {
        if (!this.watcher.pollEvents().isEmpty()) {
            this.watcherLastUpdate = new Date();
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.properties != null) {
            Set<Object> keys = this.properties.keySet();
            return Collections.enumeration(keys);
        }
        return this.parent.getKeys();
    }

    public String getBaseName() {
        return this.baseName;
    }

    protected static void loadPropertiesFromFile(Properties properties, Path externalResource) throws IOException {
        if (externalResource == null) {
            return;
        }
        InputStreamReader input = null;
        try {
            File file = externalResource.toFile();
            if (file.exists()) {
                input = new FileReader(externalResource.toFile());
                properties.load(input);
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to load message bundle:" + externalResource);
            throw ex;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }
}

