/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.document.store.service.OxDocument;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="DBDocumentService")
public class DBDocumentService
implements Serializable {
    private static final long serialVersionUID = 65734145678106186L;
    @Inject
    private Logger logger;
    @Inject
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    private PersistenceEntryManager persistenceEntryManager;
    public static final String inum = "inum";
    public static final String displayName = "displayName";
    public static final String description = "description";

    public DBDocumentService() {
    }

    public DBDocumentService(PersistenceEntryManager persistenceEntryManager) {
        this.persistenceEntryManager = persistenceEntryManager;
    }

    @PostConstruct
    public void init() {
        this.persistenceEntryManager = this.persistenceEntryManagerInstance.isResolvable() ? (PersistenceEntryManager)this.persistenceEntryManagerInstance.get() : null;
    }

    public void addOxDocument(OxDocument oxDocument) throws Exception {
        oxDocument.setCreationDate(new Date());
        this.persistenceEntryManager.persist((Object)oxDocument);
    }

    public void removeOxDocument(OxDocument oxDocument) throws Exception {
        this.persistenceEntryManager.remove((Object)oxDocument);
    }

    public OxDocument getOxDocumentByInum(String inum) throws Exception {
        OxDocument result = null;
        try {
            result = (OxDocument)this.persistenceEntryManager.find(OxDocument.class, (Object)this.getDnForOxDocument(inum));
        }
        catch (Exception e) {
            this.logger.error("Not able to find the oxDocument. Here is the exception message ", (Throwable)e);
        }
        return result;
    }

    public String getDnForOxDocument(String inum) throws Exception {
        if (StringHelper.isEmpty((String)inum)) {
            return String.format("ou=document,%s", "o=gluu");
        }
        return String.format("inum=%s,ou=document,%s", inum, "o=gluu");
    }

    public void updateOxDocument(OxDocument oxDocument) throws Exception {
        this.persistenceEntryManager.merge((Object)oxDocument);
    }

    public String generateInumForNewOxDocument() throws Exception {
        OxDocument oxDocument = new OxDocument();
        String newInum = null;
        String newDn = null;
        newInum = this.generateInumForNewOxDocumentImpl();
        newDn = this.getDnForOxDocument(newInum);
        oxDocument.setDn(newDn);
        return newInum;
    }

    public List<OxDocument> searchOxDocuments(String pattern, int sizeLimit) {
        Filter searchFilter = null;
        if (StringHelper.isNotEmpty((String)pattern)) {
            String[] targetArray = new String[]{pattern};
            Filter displayNameFilter = Filter.createSubstringFilter((String)displayName, null, (String[])targetArray, null);
            Filter descriptionFilter = Filter.createSubstringFilter((String)description, null, (String[])targetArray, null);
            searchFilter = Filter.createORFilter((Filter[])new Filter[]{displayNameFilter, descriptionFilter});
        }
        List<OxDocument> result = new ArrayList<OxDocument>();
        try {
            result = this.persistenceEntryManager.findEntries(this.getDnForOxDocument(null), OxDocument.class, searchFilter, sizeLimit);
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to find OxDocument : ", (Throwable)e);
            return result;
        }
    }

    private String generateInumForNewOxDocumentImpl() throws Exception {
        return UUID.randomUUID().toString();
    }

    public List<OxDocument> getAllOxDocumentsList(int size) {
        try {
            List oxDocuments = this.persistenceEntryManager.findEntries(this.getDnForOxDocument(null), OxDocument.class, null, size);
            return oxDocuments;
        }
        catch (Exception e) {
            this.logger.error("Failed to find OxDocument: ", (Throwable)e);
            return new ArrayList<OxDocument>();
        }
    }

    public OxDocument getOxDocumentByDn(String Dn) throws Exception {
        return (OxDocument)this.persistenceEntryManager.find(OxDocument.class, (Object)Dn);
    }

    public OxDocument getOxDocumentByDisplayName(String DisplayName) throws Exception {
        OxDocument oxDocument = new OxDocument();
        oxDocument.setDisplayName(DisplayName);
        oxDocument.setDn(this.getDnForOxDocument(null));
        List oxDocuments = this.persistenceEntryManager.findEntries((Object)oxDocument);
        if (oxDocuments != null && oxDocuments.size() > 0) {
            return (OxDocument)oxDocuments.get(0);
        }
        return null;
    }
}

