/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.conf.LocalDocumentStoreConfiguration;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LocalDocumentStoreProvider
extends DocumentStoreProvider<LocalDocumentStoreProvider> {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    private LocalDocumentStoreConfiguration localDocumentStoreConfiguration;
    private String baseLocation;

    @PostConstruct
    public void init() {
        this.localDocumentStoreConfiguration = this.documentStoreConfiguration.getLocalConfiguration();
    }

    @Override
    public void create() {
        this.log.debug("Starting LocalDocumentStoreProvider ...");
        if (StringHelper.isEmpty((String)this.localDocumentStoreConfiguration.getBaseLocation())) {
            String osName = System.getProperty("os.name");
            if (StringHelper.isNotEmpty((String)osName) && osName.toLowerCase().startsWith("windows")) {
                this.baseLocation = "";
                return;
            }
            throw new IllegalArgumentException("Base location should not be empty");
        }
        this.baseLocation = new File(this.localDocumentStoreConfiguration.getBaseLocation()).getAbsolutePath();
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration) {
        this.log = LoggerFactory.getLogger(DocumentStoreConfiguration.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying LocalDocumentStoreProvider");
        this.log.debug("Destroyed LocalDocumentStoreProvider");
    }

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.LOCAL;
    }

    @Override
    public boolean hasDocument(String path) {
        this.log.debug("Has document: '{}'", (Object)path);
        if (StringHelper.isEmpty((String)path)) {
            throw new IllegalArgumentException("Specified path should not be empty!");
        }
        File file = this.buildFilePath(path);
        return file.exists();
    }

    @Override
    public boolean saveDocument(String path, String documentContent, Charset charset) {
        boolean bl;
        block9: {
            this.log.debug("Save document: '{}'", (Object)path);
            File file = this.buildFilePath(path);
            if (!this.createParentPath(file)) {
                return false;
            }
            FileOutputStream os = FileUtils.openOutputStream((File)file);
            try {
                IOUtils.write((String)documentContent, (OutputStream)os, (Charset)charset);
                os.flush();
                bl = true;
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.log.error("Failed to write document to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
                    return false;
                }
            }
            os.close();
        }
        return bl;
    }

    @Override
    public boolean saveDocumentStream(String path, InputStream documentStream) {
        boolean bl;
        block9: {
            this.log.debug("Save document from stream: '{}'", (Object)path);
            File file = this.buildFilePath(path);
            if (!this.createParentPath(file)) {
                return false;
            }
            FileOutputStream os = FileUtils.openOutputStream((File)file);
            try {
                IOUtils.copy((InputStream)documentStream, (OutputStream)os);
                os.flush();
                bl = true;
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.log.error("Failed to write document from stream to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
                    return false;
                }
            }
            os.close();
        }
        return bl;
    }

    @Override
    public String readDocument(String path, Charset charset) {
        this.log.debug("Read document: '{}'", (Object)path);
        File file = this.buildFilePath(path);
        if (!this.createParentPath(file)) {
            return null;
        }
        try {
            return FileUtils.readFileToString((File)file, (Charset)charset);
        }
        catch (IOException ex) {
            this.log.error("Failed to read document from file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return null;
        }
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        this.log.debug("Read document as stream: '{}'", (Object)path);
        File file = this.buildFilePath(path);
        try {
            return new BufferedInputStream(FileUtils.openInputStream((File)file));
        }
        catch (IOException ex) {
            this.log.error("Failed to read document as stream from file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return null;
        }
    }

    @Override
    public boolean renameDocument(String currentPath, String destinationPath) {
        this.log.debug("Rename document: '{}' -> '{}'", (Object)currentPath, (Object)destinationPath);
        File currentFile = this.buildFilePath(currentPath);
        File destinationFile = this.buildFilePath(destinationPath);
        if (!this.removeDocument(destinationPath)) {
            this.log.error("Failed to remove destination file '{}'", (Object)destinationFile.getAbsolutePath());
        }
        try {
            currentFile.renameTo(destinationFile);
            return true;
        }
        catch (Exception ex) {
            this.log.error("Failed to rename to destination file '{}'", (Object)destinationFile.getAbsolutePath(), (Object)ex);
            return false;
        }
    }

    @Override
    public boolean removeDocument(String path) {
        this.log.debug("Remove document: '{}'", (Object)path);
        if (!this.hasDocument(path)) {
            return true;
        }
        File file = this.buildFilePath(path);
        if (!this.createParentPath(file)) {
            return false;
        }
        return FileUtils.deleteQuietly((File)file);
    }

    private boolean createParentPath(File file) {
        try {
            FileUtils.forceMkdirParent((File)file);
            return true;
        }
        catch (IOException ex) {
            this.log.error("Failed to create path to file '{}'", (Object)file.getAbsolutePath(), (Object)ex);
            return false;
        }
    }

    private File buildFilePath(String path) {
        String filePath = this.baseLocation + File.separator + path;
        return new File(filePath);
    }
}

