/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.conf.JcaDocumentStoreConfiguration;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JcaDocumentStoreProvider
extends DocumentStoreProvider<JcaDocumentStoreProvider> {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    @Inject
    private StringEncrypter stringEncrypter;
    private JcaDocumentStoreConfiguration jcaDocumentStoreConfiguration;
    private URLRemoteRepository repository;
    private SimpleCredentials credentials;
    private String workspaceName;
    private long connectionTimeout;

    @PostConstruct
    public void init() {
        this.jcaDocumentStoreConfiguration = this.documentStoreConfiguration.getJcaConfiguration();
    }

    @Override
    public void create() {
        try {
            this.log.debug("Starting JcaDocumentStoreProvider ...");
            this.decryptPassword(this.jcaDocumentStoreConfiguration);
            this.repository = new URLRemoteRepository(this.jcaDocumentStoreConfiguration.getServerUrl());
            String password = StringUtils.isBlank((String)this.jcaDocumentStoreConfiguration.getDecryptedPassword()) ? "" : this.jcaDocumentStoreConfiguration.getDecryptedPassword();
            this.credentials = new SimpleCredentials(this.jcaDocumentStoreConfiguration.getUserId(), password.toCharArray());
            this.workspaceName = this.jcaDocumentStoreConfiguration.getWorkspaceName();
            this.connectionTimeout = this.jcaDocumentStoreConfiguration.getConnectionTimeout();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error starting JcaDocumentStoreProvider", ex);
        }
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration, StringEncrypter stringEncrypter) {
        this.log = LoggerFactory.getLogger(DocumentStoreConfiguration.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
        this.stringEncrypter = stringEncrypter;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying JcaDocumentStoreProvider");
        this.repository = null;
        this.log.debug("Destroyed JcaDocumentStoreProvider");
    }

    public void setJcaDocumentStoreConfiguration(JcaDocumentStoreConfiguration jcaDocumentStoreConfiguration) {
        this.jcaDocumentStoreConfiguration = jcaDocumentStoreConfiguration;
    }

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.JCA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDocument(String path) {
        this.log.debug("Has document: '{}'", (Object)path);
        if (StringHelper.isEmpty((String)path)) {
            throw new IllegalArgumentException("Specified path should not be empty!");
        }
        Node fileNode = null;
        try {
            Session session = this.getSessionWithTimeout();
            try {
                fileNode = JcrUtils.getNodeIfExists((String)this.getNormalizedPath(path), (Session)session);
            }
            finally {
                this.closeSession(session);
            }
        }
        catch (RepositoryException ex) {
            this.log.error("Failed to check if path '" + path + "' exists in repository", (Throwable)ex);
        }
        return fileNode != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveDocument(String path, String documentContent, Charset charset) {
        this.log.debug("Save document: '{}'", (Object)path);
        String normalizedPath = this.getNormalizedPath(path);
        Session session = this.getSessionWithTimeout();
        try {
            Node contentNode = this.getOrCreateContentNode(normalizedPath, session);
            Value value = session.getValueFactory().createValue(documentContent);
            contentNode.setProperty("jcr:data", value);
            session.save();
            boolean bl = true;
            this.closeSession(session);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.closeSession(session);
                throw throwable;
            }
            catch (RepositoryException ex) {
                this.log.error("Failed to write document to file '{}'", (Object)path, (Object)ex);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveDocumentStream(String path, InputStream documentStream) {
        this.log.debug("Save document from stream: '{}'", (Object)path);
        String normalizedPath = this.getNormalizedPath(path);
        Session session = this.getSessionWithTimeout();
        try {
            Node contentNode = this.getOrCreateContentNode(normalizedPath, session);
            Binary value = session.getValueFactory().createBinary(documentStream);
            contentNode.setProperty("jcr:data", value);
            session.save();
            boolean bl = true;
            this.closeSession(session);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.closeSession(session);
                throw throwable;
            }
            catch (RepositoryException ex) {
                this.log.error("Failed to write document from stream to file '{}'", (Object)path, (Object)ex);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readDocument(String path, Charset charset) {
        this.log.debug("Read document: '{}'", (Object)path);
        String normalizedPath = this.getNormalizedPath(path);
        try {
            Session session = this.getSessionWithTimeout();
            try {
                String string;
                block14: {
                    Node fileNode = JcrUtils.getNodeIfExists((String)normalizedPath, (Session)session);
                    if (fileNode == null) {
                        this.log.error("Document file '{}' isn't exist", (Object)path);
                        String string2 = null;
                        return string2;
                    }
                    Node contentNode = fileNode.getNode("jcr:content");
                    Property property = contentNode.getProperty("jcr:data");
                    InputStream in = property.getBinary().getStream();
                    try {
                        string = IOUtils.toString((InputStream)in, (Charset)charset);
                        if (in == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return string;
            }
            finally {
                this.closeSession(session);
            }
        }
        catch (IOException session) {
        }
        catch (RepositoryException ex) {
            this.log.error("Failed to read document from file '{}'", (Object)path, (Object)ex);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream readDocumentAsStream(String path) {
        this.log.debug("Read document as stream: '{}'", (Object)path);
        String normalizedPath = this.getNormalizedPath(path);
        try {
            Session session = this.getSessionWithTimeout();
            try {
                ByteArrayInputStream byteArrayInputStream;
                block14: {
                    Node fileNode = JcrUtils.getNodeIfExists((String)normalizedPath, (Session)session);
                    if (fileNode == null) {
                        this.log.error("Document file '{}' isn't exist", (Object)path);
                        InputStream inputStream = null;
                        return inputStream;
                    }
                    Node contentNode = fileNode.getNode("jcr:content");
                    Property property = contentNode.getProperty("jcr:data");
                    InputStream in = property.getBinary().getStream();
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)in, (OutputStream)bos);
                        byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
                        if (in == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return byteArrayInputStream;
            }
            finally {
                this.closeSession(session);
            }
        }
        catch (IOException session) {
        }
        catch (RepositoryException ex) {
            this.log.error("Failed to read document as stream from file '{}'", (Object)path, (Object)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameDocument(String currentPath, String destinationPath) {
        this.log.debug("Rename document: '{}' -> '{}'", (Object)currentPath, (Object)destinationPath);
        String normalizedCurrentPath = this.getNormalizedPath(currentPath);
        String normalizedDestinationPath = this.getNormalizedPath(destinationPath);
        Session session = this.getSessionWithTimeout();
        try {
            this.removeDocument(normalizedDestinationPath, session);
            this.createPath(normalizedDestinationPath, session);
            session.move(normalizedCurrentPath, normalizedDestinationPath);
            session.save();
            boolean bl = true;
            this.closeSession(session);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.closeSession(session);
                throw throwable;
            }
            catch (RepositoryException ex) {
                this.log.error("Failed to rename to destination file '{}'", (Object)destinationPath, (Object)ex);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDocument(String path) {
        this.log.debug("Remove document: '{}'", (Object)path);
        Session session = this.getSessionWithTimeout();
        try {
            this.removeDocument(path, session);
            session.save();
            boolean bl = true;
            this.closeSession(session);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.closeSession(session);
                throw throwable;
            }
            catch (RepositoryException ex) {
                this.log.error("Failed to remove document file '{}'", (Object)path, (Object)ex);
                return false;
            }
        }
    }

    private void removeDocument(String path, Session session) throws RepositoryException, VersionException, LockException, ConstraintViolationException, AccessDeniedException {
        Node fileNode = JcrUtils.getNodeIfExists((String)this.getNormalizedPath(path), (Session)session);
        if (fileNode != null) {
            fileNode.remove();
        }
    }

    private void decryptPassword(JcaDocumentStoreConfiguration jcaDocumentStoreConfiguration) {
        try {
            String encryptedPassword = jcaDocumentStoreConfiguration.getPassword();
            if (StringUtils.isNotBlank((String)encryptedPassword)) {
                jcaDocumentStoreConfiguration.setDecryptedPassword(this.stringEncrypter.decrypt(encryptedPassword));
                this.log.trace("Decrypted JCA password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException ex) {
            jcaDocumentStoreConfiguration.setDecryptedPassword(jcaDocumentStoreConfiguration.getPassword());
            this.log.error("Error during JCA password decryption", (Throwable)ex);
        }
    }

    private Session getSession() throws RepositoryException {
        return this.repository.login((Credentials)this.credentials, this.workspaceName);
    }

    public Session getSessionWithTimeout() throws RepositoryException {
        try {
            CallableSession cs = new CallableSession(this.repository, this.credentials, this.workspaceName);
            FutureTask<Session> future = new FutureTask<Session>(cs);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(future);
            return future.get(this.connectionTimeout * 1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new RepositoryException("Failed to get session", (Throwable)ex);
        }
    }

    private void closeSession(Session session) {
        if (session != null && session.isLive()) {
            session.logout();
        }
    }

    private String getNormalizedPath(String path) {
        return path.replace("\\", "/").replace(" ", "");
    }

    private Node getOrCreateContentNode(String path, Session session) throws RepositoryException {
        Node fileNode = JcrUtils.getNodeIfExists((String)this.getNormalizedPath(path), (Session)session);
        Node contentNode = null;
        if (fileNode == null) {
            fileNode = JcrUtils.getOrCreateByPath((String)path, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (String)"{http://www.jcp.org/jcr/nt/1.0}file", (Session)session, (boolean)false);
            contentNode = fileNode.addNode("jcr:content", "{http://www.jcp.org/jcr/nt/1.0}resource");
        } else {
            contentNode = fileNode.getNode("jcr:content");
        }
        return contentNode;
    }

    private void createPath(String path, Session session) throws RepositoryException {
        File filePath = new File(path);
        String folderPath = filePath.getParentFile().getPath();
        String normalizedFolderPath = this.getNormalizedPath(folderPath);
        JcrUtils.getOrCreateByPath((String)normalizedFolderPath, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (Session)session);
    }

    public boolean isConnected() {
        this.log.debug("Check if server available");
        Node fileNode = null;
        try {
            Session session = this.getSessionWithTimeout();
            try {
                fileNode = JcrUtils.getNodeIfExists((String)this.getNormalizedPath("/"), (Session)session);
            }
            finally {
                this.closeSession(session);
            }
        }
        catch (RepositoryException ex) {
            this.log.error("Failed to check if server available", (Throwable)ex);
        }
        return fileNode != null;
    }

    class CallableSession
    implements Callable<Session> {
        private URLRemoteRepository repository;
        private SimpleCredentials credentials;
        private String workspaceName;

        public CallableSession(URLRemoteRepository repository, SimpleCredentials credentials, String workspaceName) {
            this.repository = repository;
            this.credentials = credentials;
            this.workspaceName = workspaceName;
        }

        @Override
        public Session call() throws Exception {
            return this.repository.login((Credentials)this.credentials, this.workspaceName);
        }
    }
}

