/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.document.store.conf.DBDocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.gluu.service.document.store.service.DBDocumentService;
import org.gluu.service.document.store.service.OxDocument;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DBDocumentStoreProvider
extends DocumentStoreProvider<DBDocumentStoreProvider> {
    @Inject
    private Logger log;
    @Inject
    private DBDocumentService documentService;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    private DBDocumentStoreConfiguration dbDocumentStoreConfiguration;

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.DB;
    }

    @PostConstruct
    public void init() {
        this.dbDocumentStoreConfiguration = this.documentStoreConfiguration.getDbConfiguration();
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration, PersistenceEntryManager persistenceEntryManager) {
        this.log = LoggerFactory.getLogger(DBDocumentStoreProvider.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
        if (this.documentService == null) {
            this.documentService = new DBDocumentService(persistenceEntryManager);
        }
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean hasDocument(String DisplayName) {
        this.log.debug("Has document: '{}'", (Object)DisplayName);
        if (StringHelper.isEmpty((String)DisplayName)) {
            throw new IllegalArgumentException("Specified path should not be empty!");
        }
        OxDocument oxDocument = null;
        try {
            oxDocument = this.documentService.getOxDocumentByDisplayName(DisplayName);
        }
        catch (Exception e) {
            this.log.error("Failed to check if path '" + DisplayName + "' exists in repository", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean saveDocument(String name, String documentContent, Charset charset) {
        this.log.debug("Save document: '{}'", (Object)name);
        OxDocument oxDocument = new OxDocument();
        oxDocument.setDocument(documentContent);
        oxDocument.setDisplayName(name);
        try {
            oxDocument.setInum(this.documentService.generateInumForNewOxDocument());
            String dn = "inum=" + oxDocument.getInum() + ",ou=document,o=gluu";
            oxDocument.setDn(dn);
            oxDocument.setDescription(name);
            oxDocument.setOxEnabled("true");
            oxDocument.setOxModuleProperty("oxtrusr server");
            this.documentService.addOxDocument(oxDocument);
            return true;
        }
        catch (Exception ex) {
            this.log.error("Failed to write document to file '{}'", (Object)name, (Object)ex);
            return false;
        }
    }

    @Override
    public boolean saveDocumentStream(String name, InputStream documentStream) {
        OxDocument oxDocument = new OxDocument();
        oxDocument.setDisplayName(name);
        try {
            String documentContent = Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)documentStream));
            oxDocument.setDocument(documentContent);
            String inum = this.documentService.generateInumForNewOxDocument();
            oxDocument.setInum(inum);
            String dn = "inum=" + oxDocument.getInum() + ",ou=document,o=gluu";
            oxDocument.setDn(dn);
            oxDocument.setDescription(name);
            oxDocument.setOxEnabled("true");
            oxDocument.setOxModuleProperty("oxtrusr server");
            this.documentService.addOxDocument(oxDocument);
            return true;
        }
        catch (IOException e) {
            this.log.error("Failed to write document from stream to file '{}'", (Object)name, (Object)e);
        }
        catch (Exception e) {
            this.log.error("Failed to write document from stream to file '{}'", (Object)name, (Object)e);
        }
        return false;
    }

    @Override
    public String readDocument(String name, Charset charset) {
        this.log.debug("Read document: '{}'", (Object)name);
        try {
            OxDocument oxDocument = this.documentService.getOxDocumentByDisplayName(name);
            if (oxDocument != null) {
                return oxDocument.getDocument();
            }
        }
        catch (Exception e) {
            this.log.error("Failed to read document as stream from file '{}'", (Object)name, (Object)e);
        }
        return null;
    }

    @Override
    public InputStream readDocumentAsStream(String name) {
        this.log.debug("Read document as stream: '{}'", (Object)name);
        String filecontecnt = this.readDocument(name, null);
        if (filecontecnt == null) {
            this.log.error("Document file '{}' isn't exist", (Object)name);
            return null;
        }
        ByteArrayInputStream InputStream2 = new ByteArrayInputStream(Base64.getDecoder().decode(filecontecnt));
        return InputStream2;
    }

    @Override
    public boolean renameDocument(String currentDisplayName, String destinationDisplayName) {
        this.log.debug("Rename document: '{}' -> '{}'", (Object)currentDisplayName, (Object)destinationDisplayName);
        try {
            OxDocument oxDocument = this.documentService.getOxDocumentByDisplayName(currentDisplayName);
            if (oxDocument == null) {
                this.log.error("Document doesn't Exist with the name  '{}'", (Object)currentDisplayName);
                return false;
            }
            oxDocument.setDisplayName(destinationDisplayName);
            this.documentService.updateOxDocument(oxDocument);
            OxDocument oxDocumentDestination = this.documentService.getOxDocumentByDisplayName(destinationDisplayName);
            if (oxDocumentDestination == null) {
                this.log.error("Failed to rename to destination file '{}'", (Object)destinationDisplayName);
                return false;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to rename to destination file '{}'", (Object)destinationDisplayName);
        }
        return true;
    }

    @Override
    public boolean removeDocument(String inum) {
        this.log.debug("Remove document: '{}'", (Object)inum);
        try {
            OxDocument oxDocument = this.documentService.getOxDocumentByInum(inum);
            if (oxDocument == null) {
                this.log.error(" document not exist file '{}'", (Object)inum);
                return false;
            }
            this.documentService.removeOxDocument(oxDocument);
            OxDocument checkOxDocument = this.documentService.getOxDocumentByInum(inum);
            return checkOxDocument == null;
        }
        catch (Exception e) {
            this.log.error("Failed to remove document file '{}'", (Object)inum, (Object)e);
            return false;
        }
    }
}

