/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store;

import org.gluu.persist.PersistenceEntryManager;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.provider.DBDocumentStoreProvider;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.gluu.service.document.store.provider.JcaDocumentStoreProvider;
import org.gluu.service.document.store.provider.LocalDocumentStoreProvider;
import org.gluu.service.document.store.provider.WebDavDocumentStoreProvider;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneDocumentStoreProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneDocumentStoreProviderFactory.class);
    private StringEncrypter stringEncrypter;
    private PersistenceEntryManager persistenceEntryManager;

    public StandaloneDocumentStoreProviderFactory() {
    }

    public StandaloneDocumentStoreProviderFactory(StringEncrypter stringEncrypter) {
        this.stringEncrypter = stringEncrypter;
    }

    public StandaloneDocumentStoreProviderFactory(PersistenceEntryManager persistenceEntryManager) {
        this.persistenceEntryManager = persistenceEntryManager;
    }

    public DocumentStoreProvider getDocumentStoreProvider(DocumentStoreConfiguration documentStoreConfiguration) {
        DocumentStoreType documentStoreType = documentStoreConfiguration.getDocumentStoreType();
        if (documentStoreType == null) {
            LOG.error("Failed to initialize documentStoreProvider, documentStoreProviderType is null. Fallback to LOCAL type.");
            documentStoreType = DocumentStoreType.LOCAL;
        }
        DocumentStoreProvider documentStoreProvider = null;
        switch (documentStoreType) {
            case LOCAL: {
                LocalDocumentStoreProvider localDocumentStoreProvider = new LocalDocumentStoreProvider();
                localDocumentStoreProvider.configure(documentStoreConfiguration);
                localDocumentStoreProvider.init();
                documentStoreProvider = localDocumentStoreProvider;
                break;
            }
            case JCA: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                JcaDocumentStoreProvider jcaDocumentStoreProvider = new JcaDocumentStoreProvider();
                jcaDocumentStoreProvider.configure(documentStoreConfiguration, this.stringEncrypter);
                jcaDocumentStoreProvider.init();
                documentStoreProvider = jcaDocumentStoreProvider;
                break;
            }
            case WEB_DAV: {
                if (this.stringEncrypter == null) {
                    throw new RuntimeException("Factory is not initialized properly. stringEncrypter is not specified");
                }
                WebDavDocumentStoreProvider webDavDocumentStoreProvider = new WebDavDocumentStoreProvider();
                webDavDocumentStoreProvider.configure(documentStoreConfiguration, this.stringEncrypter);
                webDavDocumentStoreProvider.init();
                documentStoreProvider = webDavDocumentStoreProvider;
                break;
            }
            case DB: {
                DBDocumentStoreProvider dbDocumentStoreProvider = new DBDocumentStoreProvider();
                dbDocumentStoreProvider.configure(documentStoreConfiguration, this.persistenceEntryManager);
                dbDocumentStoreProvider.init();
                documentStoreProvider = dbDocumentStoreProvider;
            }
        }
        if (documentStoreProvider == null) {
            throw new RuntimeException("Failed to initialize documentStoreProvider, documentStoreProviderType is unsupported: " + (Object)((Object)documentStoreType));
        }
        documentStoreProvider.create();
        return documentStoreProvider;
    }
}

