/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.provider;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.conf.WebDavDocumentStoreConfiguration;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class WebDavDocumentStoreProvider
extends DocumentStoreProvider<WebDavDocumentStoreProvider> {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    @Inject
    private StringEncrypter stringEncrypter;
    protected HttpClientContext context = HttpClientContext.create();
    private WebDavDocumentStoreConfiguration webDavDocumentStoreConfiguration;
    private Sardine client;
    private HttpClient httpClient;
    private String baseServerUrl;
    private int connectionTimeout;

    @PostConstruct
    public void init() {
        this.webDavDocumentStoreConfiguration = this.documentStoreConfiguration.getWebDavConfiguration();
    }

    @Override
    public void create() {
        try {
            this.log.debug("Starting WebDavDocumentStoreProvider ...");
            this.decryptPassword(this.webDavDocumentStoreConfiguration);
            String password = StringUtils.isBlank((String)this.webDavDocumentStoreConfiguration.getDecryptedPassword()) ? "" : this.webDavDocumentStoreConfiguration.getDecryptedPassword();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.webDavDocumentStoreConfiguration.getUserId(), password);
            this.connectionTimeout = this.webDavDocumentStoreConfiguration.getConnectionTimeout();
            this.httpClient = this.createHttpClient(credentials, this.connectionTimeout * 1000);
            this.baseServerUrl = this.webDavDocumentStoreConfiguration.getServerUrl() + "/" + this.webDavDocumentStoreConfiguration.getWorkspaceName();
            this.client = SardineFactory.begin((String)this.webDavDocumentStoreConfiguration.getUserId(), (String)password);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error starting JcaDocumentStoreProvider", ex);
        }
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration, StringEncrypter stringEncrypter) {
        this.log = LoggerFactory.getLogger(WebDavDocumentStoreProvider.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
        this.stringEncrypter = stringEncrypter;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying WebDavDocumentStoreProvider");
        this.client = null;
        this.log.debug("Destroyed WebDavDocumentStoreProvider");
    }

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.WEB_DAV;
    }

    @Override
    public boolean hasDocument(String path) {
        return false;
    }

    @Override
    public boolean saveDocument(String path, String documentContent, Charset charset) {
        this.log.debug("Save document: '{}'", (Object)path);
        String normalizedPath = this.getNormalizedPath(path);
        try {
            HttpPut method = new HttpPut(this.baseServerUrl + "/" + normalizedPath);
            StringEntity entity = new StringEntity(documentContent, charset);
            method.setEntity((HttpEntity)entity);
            BasicHttpContext requestLocalContext = new BasicHttpContext((HttpContext)this.context);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)requestLocalContext);
            int statusCode = response.getStatusLine().getStatusCode();
            return statusCode == 201 || statusCode == 204;
        }
        catch (IOException ex) {
            this.log.error("Failed to write document to file '{}'", (Object)path, (Object)ex);
            return false;
        }
    }

    @Override
    public boolean saveDocumentStream(String path, InputStream documentStream) {
        this.log.debug("Save document from stream: '{}'", (Object)path);
        String normalizedPath = this.getNormalizedPath(path);
        try {
            HttpPut method = new HttpPut(this.baseServerUrl + "/" + normalizedPath);
            InputStreamEntity entity = new InputStreamEntity(documentStream);
            method.setEntity((HttpEntity)entity);
            BasicHttpContext requestLocalContext = new BasicHttpContext((HttpContext)this.context);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)requestLocalContext);
            return response.getStatusLine().getStatusCode() == 201;
        }
        catch (IOException ex) {
            this.log.error("Failed to write document from stream to file '{}'", (Object)path, (Object)ex);
            return false;
        }
    }

    @Override
    public String readDocument(String path, Charset charset) {
        return null;
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        return null;
    }

    @Override
    public boolean renameDocument(String currentPath, String destinationPath) {
        return false;
    }

    @Override
    public boolean removeDocument(String path) {
        return false;
    }

    private void createPath(String path) throws RepositoryException {
    }

    private HttpClient createHttpClient(UsernamePasswordCredentials credentials, int timeoutInMillis) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (Credentials)credentials);
        DefaultSchemePortResolver portResolver = new DefaultSchemePortResolver(){

            public int resolve(HttpHost host) throws UnsupportedSchemeException {
                Args.notNull((Object)host, (String)"HTTP host");
                int port = host.getPort();
                if (port > 0) {
                    return port;
                }
                String name = host.getSchemeName();
                if (name.equalsIgnoreCase("http")) {
                    return 8080;
                }
                if (name.equalsIgnoreCase("https")) {
                    return 8443;
                }
                return super.resolve(host);
            }
        };
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").setSocketTimeout(timeoutInMillis).setExpectContinueEnabled(false).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setConnectionManager((HttpClientConnectionManager)cm).build();
        cm.setMaxTotal(50);
        cm.setDefaultMaxPerRoute(10);
        this.context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        return httpClient;
    }

    private void decryptPassword(WebDavDocumentStoreConfiguration webDocumentStoreConfiguration) {
        try {
            String encryptedPassword = webDocumentStoreConfiguration.getPassword();
            if (StringUtils.isNotBlank((String)encryptedPassword)) {
                webDocumentStoreConfiguration.setDecryptedPassword(this.stringEncrypter.decrypt(encryptedPassword));
                this.log.trace("Decrypted WebDAV password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException ex) {
            this.log.error("Error during WebDAV password decryption", (Throwable)ex);
        }
    }

    private String getNormalizedPath(String path) {
        String resultPath = path.replace("\\", "/").replace(" ", "");
        if (resultPath.startsWith("/")) {
            resultPath = resultPath.substring(1);
        }
        return resultPath;
    }
}

