/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.provider;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.gluu.service.document.store.LocalDocumentStore;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.gluu.service.document.store.provider.JcaDocumentStoreProvider;
import org.gluu.service.document.store.provider.LocalDocumentStoreProvider;
import org.gluu.service.document.store.provider.WebDavDocumentStoreProvider;
import org.slf4j.Logger;

@ApplicationScoped
public class DocumentStoreProviderFactory {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    @Inject
    @Any
    private Instance<DocumentStoreProvider> instance;

    @Produces
    @ApplicationScoped
    public DocumentStoreProvider getDocumentStoreProvider() {
        this.log.debug("Started to create document store provider");
        return this.getDocumentStoreProvider(this.documentStoreConfiguration);
    }

    public DocumentStoreProvider getDocumentStoreProvider(DocumentStoreConfiguration documentStoreConfiguration) {
        DocumentStoreType documentStoreType = documentStoreConfiguration.getDocumentStoreType();
        if (documentStoreType == null) {
            this.log.error("Failed to initialize DocumentStoreProvider, DocumentStoreProviderType is null. Fallback to LOCAL type.");
            documentStoreType = DocumentStoreType.LOCAL;
        }
        DocumentStoreProvider documentStoreProvider = null;
        switch (documentStoreType) {
            case LOCAL: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(LocalDocumentStoreProvider.class, new Annotation[0]).get();
                break;
            }
            case JCA: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(JcaDocumentStoreProvider.class, new Annotation[0]).get();
                break;
            }
            case WEB_DAV: {
                documentStoreProvider = (DocumentStoreProvider)this.instance.select(WebDavDocumentStoreProvider.class, new Annotation[0]).get();
            }
        }
        if (documentStoreProvider == null) {
            throw new RuntimeException("Failed to initialize DocumentStoreProvider, DocumentStoreProviderType is unsupported: " + (Object)((Object)documentStoreType));
        }
        documentStoreProvider.create();
        return documentStoreProvider;
    }

    @Produces
    @ApplicationScoped
    @LocalDocumentStore
    public DocumentStoreProvider getLocalDocumentStoreProvider() {
        this.log.debug("Started to create local document store provider");
        DocumentStoreType documentStoreType = DocumentStoreType.LOCAL;
        DocumentStoreProvider documentStoreProvider = (DocumentStoreProvider)this.instance.select(LocalDocumentStoreProvider.class, new Annotation[0]).get();
        if (documentStoreProvider == null) {
            throw new RuntimeException("Failed to initialize DocumentStoreProvider, DocumentStoreProviderType is unsupported: " + (Object)((Object)documentStoreType));
        }
        documentStoreProvider.create();
        return documentStoreProvider;
    }
}

