/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.provider;

import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.service.document.store.conf.DocumentStoreConfiguration;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.conf.WebDavDocumentStoreConfiguration;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class WebDavDocumentStoreProvider
extends DocumentStoreProvider<WebDavDocumentStoreProvider> {
    @Inject
    private Logger log;
    @Inject
    private DocumentStoreConfiguration documentStoreConfiguration;
    private WebDavDocumentStoreConfiguration webDavDocumentStoreConfiguration;

    @PostConstruct
    public void init() {
        this.webDavDocumentStoreConfiguration = this.documentStoreConfiguration.getWebDavConfiguration();
    }

    @Override
    public void create() {
        this.log.debug("Starting LocalDocumentStoreProvider ...");
    }

    public void configure(DocumentStoreConfiguration documentStoreConfiguration) {
        this.log = LoggerFactory.getLogger(DocumentStoreConfiguration.class);
        this.documentStoreConfiguration = documentStoreConfiguration;
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying LocalDocumentStoreProvider");
        this.log.debug("Destroyed LocalDocumentStoreProvider");
    }

    @Override
    public DocumentStoreType getProviderType() {
        return DocumentStoreType.WEB_DAV;
    }

    @Override
    public boolean hasDocument(String path) {
        return false;
    }

    @Override
    public boolean saveDocument(String path, String documentContent, Charset charset) {
        return false;
    }

    @Override
    public boolean saveDocumentStream(String path, InputStream documentStream) {
        return false;
    }

    @Override
    public String readDocument(String path, Charset charset) {
        return null;
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        return null;
    }

    @Override
    public boolean renameDocument(String currentPath, String destinationPath) {
        return false;
    }

    @Override
    public boolean removeDocument(String path) {
        return false;
    }
}

