/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.document.store.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.gluu.service.document.store.conf.DocumentStoreType;
import org.gluu.service.document.store.provider.DocumentStore;
import org.gluu.service.document.store.provider.DocumentStoreProvider;
import org.slf4j.Logger;

public abstract class BaseDocumentStoreService
implements DocumentStore {
    @Inject
    private Logger log;

    @Override
    public boolean hasDocument(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.hasDocument(path);
    }

    @Override
    public boolean saveDocument(String path, String documentContent, Charset charset) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.saveDocument(path, documentContent, charset);
    }

    @Override
    public boolean saveDocumentStream(String path, InputStream documentStream) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.saveDocumentStream(path, documentStream);
    }

    @Override
    public String readDocument(String path, Charset charset) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.readDocument(path, charset);
    }

    @Override
    public InputStream readDocumentAsStream(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.readDocumentAsStream(path);
    }

    @Override
    public boolean renameDocument(String currentPath, String destinationPath) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.renameDocument(currentPath, destinationPath);
    }

    @Override
    public boolean removeDocument(String path) {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.removeDocument(path);
    }

    @Override
    public DocumentStoreType getProviderType() {
        DocumentStoreProvider documentStoreProvider = this.getDocumentStoreProvider();
        return documentStoreProvider.getProviderType();
    }

    protected abstract DocumentStoreProvider getDocumentStoreProvider();
}

