/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.operation.impl;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.Delete;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.MutateLimitPath;
import com.couchbase.client.java.query.dsl.path.OffsetPath;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.subdoc.MutateInBuilder;
import com.couchbase.client.java.subdoc.MutationSpec;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gluu.persist.couchbase.impl.CouchbaseBatchOperationWraper;
import org.gluu.persist.couchbase.model.BucketMapping;
import org.gluu.persist.couchbase.model.SearchReturnDataType;
import org.gluu.persist.couchbase.operation.CouchbaseOperationService;
import org.gluu.persist.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.persist.couchbase.operation.watch.OperationDurationUtil;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.exception.operation.EntryNotFoundException;
import org.gluu.persist.exception.operation.PersistenceException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.operation.auth.PasswordEncryptionHelper;
import org.gluu.persist.operation.auth.PasswordEncryptionMethod;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseOperationsServiceImpl
implements CouchbaseOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);
    private CouchbaseConnectionProvider connectionProvider;

    private CouchbaseOperationsServiceImpl() {
    }

    public CouchbaseOperationsServiceImpl(CouchbaseConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public CouchbaseConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public boolean authenticate(String key, String password) throws SearchException {
        return this.authenticateImpl(key, password);
    }

    private boolean authenticateImpl(String key, String password) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = false;
        if (password != null) {
            JsonObject entry = this.lookup(key, "userPassword");
            Object userPasswordObj = entry.get("userPassword");
            String userPassword = null;
            if (userPasswordObj instanceof JsonArray) {
                userPassword = ((JsonArray)userPasswordObj).getString(0);
            } else if (userPasswordObj instanceof String) {
                userPassword = (String)userPasswordObj;
            }
            if (userPassword != null) {
                result = PasswordEncryptionHelper.compareCredentials((byte[])password.getBytes(), (byte[])userPassword.getBytes());
            }
        }
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: bind, duration: {}, key: {}", new Object[]{duration, key});
        return result;
    }

    @Override
    public boolean addEntry(String key, JsonObject jsonObject) throws DuplicateEntryException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.addEntryImpl(key, jsonObject);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: add, duration: {}, key: {}, json: {}", new Object[]{duration, key, jsonObject});
        return result;
    }

    private boolean addEntryImpl(String key, JsonObject jsonObject) throws PersistenceException {
        try {
            BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
            JsonDocument jsonDocument = JsonDocument.create((String)key, (JsonObject)jsonObject);
            JsonDocument result = (JsonDocument)bucketMapping.getBucket().upsert((Document)jsonDocument);
            if (result != null) {
                return true;
            }
        }
        catch (CouchbaseException ex) {
            throw new PersistenceException("Failed to add entry", (Throwable)ex);
        }
        return false;
    }

    @Deprecated
    protected boolean updateEntry(String key, JsonObject attrs) throws UnsupportedOperationException, SearchException {
        ArrayList<MutationSpec> mods = new ArrayList<MutationSpec>();
        for (Map.Entry attrEntry : attrs.toMap().entrySet()) {
            String attributeName = (String)attrEntry.getKey();
            Object attributeValue = attrEntry.getValue();
            if (attributeName.equalsIgnoreCase("objectClass") || attributeName.equalsIgnoreCase("dn") || attributeName.equalsIgnoreCase("userPassword") || attributeValue == null) continue;
            mods.add(new MutationSpec(Mutation.REPLACE, attributeName, attributeValue));
        }
        return this.updateEntry(key, mods);
    }

    @Override
    public boolean updateEntry(String key, List<MutationSpec> mods) throws UnsupportedOperationException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.updateEntryImpl(key, mods);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: modify, duration: {}, key: {}, mods: {}", new Object[]{duration, key, mods});
        return result;
    }

    private boolean updateEntryImpl(String key, List<MutationSpec> mods) throws SearchException {
        try {
            BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
            MutateInBuilder builder = bucketMapping.getBucket().mutateIn(key);
            return this.modifyEntry(builder, mods);
        }
        catch (CouchbaseException ex) {
            throw new SearchException("Failed to update entry", (Throwable)ex);
        }
    }

    protected boolean modifyEntry(MutateInBuilder builder, List<MutationSpec> mods) throws UnsupportedOperationException, SearchException {
        try {
            for (MutationSpec mod : mods) {
                Mutation type = mod.type();
                if (Mutation.DICT_ADD == type) {
                    builder.insert(mod.path(), mod.fragment());
                    continue;
                }
                if (Mutation.REPLACE == type) {
                    builder.replace(mod.path(), mod.fragment());
                    continue;
                }
                if (Mutation.DELETE == type) {
                    builder.remove(mod.path());
                    continue;
                }
                throw new UnsupportedOperationException("Operation type '" + type + "' is not implemented");
            }
            DocumentFragment result = builder.execute();
            if (result.size() > 0) {
                return result.status(0).isSuccess();
            }
            return false;
        }
        catch (CouchbaseException ex) {
            throw new SearchException("Failed to update entry", (Throwable)ex);
        }
    }

    @Override
    public boolean delete(String key) throws EntryNotFoundException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.deleteImpl(key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete, duration: {}, key: {}", new Object[]{duration, key});
        return result;
    }

    private boolean deleteImpl(String key) throws EntryNotFoundException {
        try {
            BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
            JsonDocument result = bucketMapping.getBucket().remove(key);
            return result != null && result.id() != null;
        }
        catch (CouchbaseException ex) {
            throw new EntryNotFoundException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public boolean deleteRecursively(String key) throws EntryNotFoundException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = this.deleteRecursivelyImpl(key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete_tree, duration: {}, key: {}", new Object[]{duration, key});
        return result;
    }

    private boolean deleteRecursivelyImpl(String key) throws SearchException, EntryNotFoundException {
        try {
            BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
            MutateLimitPath deleteQuery = Delete.deleteFrom((Expression)Expression.i((String[])new String[]{bucketMapping.getBucketName()})).where(Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"})));
            N1qlQueryResult result = bucketMapping.getBucket().query((Statement)deleteQuery);
            if (!result.finalSuccess()) {
                throw new SearchException(String.format("Failed to delete entries. Query: '%s'. Errors: %s", bucketMapping, result.errors()), result.info().errorCount());
            }
            return true;
        }
        catch (CouchbaseException ex) {
            throw new EntryNotFoundException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public JsonObject lookup(String key, String ... attributes) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        JsonObject result = this.lookupImpl(key, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: lookup, duration: {}, key: {}, attributes: {}", new Object[]{duration, key, attributes});
        return result;
    }

    private JsonObject lookupImpl(String key, String ... attributes) throws SearchException {
        try {
            BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
            if (ArrayHelper.isEmpty((Object[])attributes)) {
                JsonDocument doc = bucketMapping.getBucket().get(key);
                if (doc != null) {
                    return (JsonObject)doc.content();
                }
            } else {
                SimpleN1qlQuery query = N1qlQuery.simple((Statement)Select.select((String[])attributes).from(Expression.i((String[])new String[]{bucketMapping.getBucketName()})).useKeys(Expression.s((String[])new String[]{key})).limit(1));
                N1qlQueryResult result = bucketMapping.getBucket().query((N1qlQuery)query);
                if (!result.finalSuccess()) {
                    throw new SearchException(String.format("Failed to lookup entry. Errors: %s", result.errors()), result.info().errorCount());
                }
                if (result.allRows().size() == 1) {
                    return ((N1qlQueryRow)result.allRows().get(0)).value();
                }
            }
        }
        catch (CouchbaseException ex) {
            throw new SearchException("Failed to lookup entry", (Throwable)ex);
        }
        throw new SearchException("Failed to lookup entry");
    }

    @Override
    public <O> PagedResult<JsonObject> search(String key, Expression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        PagedResult<JsonObject> result = this.searchImpl(key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: search, duration: {}, key: {}, expression: {}, scope: {}, attributes: {}, orderBy: {}, batchOperationWraper: {}, returnDataType: {}, start: {}, count: {}, pageSize: {}", new Object[]{duration, key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize});
        return result;
    }

    private <O> PagedResult<JsonObject> searchImpl(String key, Expression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        GroupByPath selectQuery;
        String[] select;
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        Bucket bucket = bucketMapping.getBucket();
        BatchOperation<O> ldapBatchOperation = null;
        if (batchOperationWraper != null) {
            ldapBatchOperation = batchOperationWraper.getBatchOperation();
        }
        if (LOG.isTraceEnabled() && StringHelper.equalsIgnoreCase((String)key, (String)"_")) {
            LOG.trace("Search in whole DB tree", (Throwable)new Exception());
        }
        Expression scopeExpression = scope == null ? null : (SearchScope.BASE == scope ? Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"})).and(Expression.path((Object[])new Object[]{"META().id"}).notLike(Expression.s((String[])new String[]{key + "\\\\_%\\\\_"}))) : Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"})));
        Expression finalExpression = scopeExpression;
        if (expression != null) {
            finalExpression = scopeExpression.and(expression);
        }
        if ((select = attributes) == null) {
            select = new String[]{"gluu_doc.*", "dn"};
        } else if (select.length == 1 && StringHelper.isEmpty((String)select[0])) {
            select = new String[]{"dn"};
        } else {
            boolean hasDn = Arrays.asList(select).contains("dn");
            if (!hasDn) {
                select = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{select, {"dn"}});
            }
        }
        GroupByPath baseQuery = selectQuery = Select.select((String[])select).from(Expression.i((String[])new String[]{bucketMapping.getBucketName()})).as("gluu_doc").where(finalExpression);
        if (orderBy != null) {
            baseQuery = selectQuery.orderBy(orderBy);
        }
        ArrayList searchResultList = new ArrayList();
        if (SearchReturnDataType.SEARCH == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            N1qlQueryResult lastResult;
            if (pageSize > 0) {
                Statement query = null;
                try {
                    List lastSearchResultList;
                    int resultCount = 0;
                    do {
                        boolean collectSearchResult = true;
                        int currentLimit = pageSize;
                        if (count > 0) {
                            currentLimit = Math.min(pageSize, count - resultCount);
                        }
                        query = baseQuery.limit(currentLimit).offset(start + resultCount);
                        LOG.debug("Execution query: '" + query + "'");
                        lastResult = bucket.query(query);
                        if (!lastResult.finalSuccess()) {
                            throw new SearchException(String.format("Failed to search entries. Query: '%s'. Error: ", query, lastResult.errors()), lastResult.info().errorCount());
                        }
                        lastSearchResultList = lastResult.allRows();
                        if (ldapBatchOperation != null) {
                            collectSearchResult = ldapBatchOperation.collectSearchResult(lastSearchResultList.size());
                        }
                        if (collectSearchResult) {
                            searchResultList.addAll(lastSearchResultList);
                        }
                        if (ldapBatchOperation == null) continue;
                        List<O> entries = batchOperationWraper.createEntities(lastSearchResultList);
                        ldapBatchOperation.performAction(entries);
                    } while ((count <= 0 || (resultCount += lastSearchResultList.size()) < count) && lastSearchResultList.size() > 0 && lastSearchResultList.size() > 0);
                }
                catch (CouchbaseException ex) {
                    throw new SearchException("Failed to search entries. Query: '" + query + "'", (Throwable)ex);
                }
            }
            try {
                GroupByPath query = baseQuery;
                if (count > 0) {
                    query = ((LimitPath)query).limit(count);
                }
                if (start > 0) {
                    query = ((OffsetPath)query).offset(start);
                }
                LOG.debug("Execution query: '" + query + "'");
                lastResult = bucket.query((Statement)query);
                if (!lastResult.finalSuccess()) {
                    throw new SearchException(String.format("Failed to search entries. Query: '%s'. Error: ", baseQuery, lastResult.errors()), lastResult.info().errorCount());
                }
                searchResultList.addAll(lastResult.allRows());
            }
            catch (CouchbaseException ex) {
                throw new SearchException("Failed to search entries. Query: '" + baseQuery.toString() + "'", (Throwable)ex);
            }
        }
        ArrayList<JsonObject> resultRows = new ArrayList<JsonObject>(searchResultList.size());
        for (N1qlQueryRow row : searchResultList) {
            resultRows.add(row.value());
        }
        PagedResult result = new PagedResult();
        result.setEntries(resultRows);
        result.setEntriesCount(resultRows.size());
        result.setStart(start);
        if (SearchReturnDataType.COUNT == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            GroupByPath selectCountQuery = Select.select((String[])new String[]{"COUNT(*) as TOTAL"}).from(Expression.i((String[])new String[]{bucketMapping.getBucketName()})).where(finalExpression);
            try {
                LOG.debug("Calculating count. Execution query: '" + selectCountQuery + "'");
                N1qlQueryResult countResult = bucket.query((Statement)selectCountQuery);
                if (!countResult.finalSuccess() || countResult.info().resultCount() != 1) {
                    throw new SearchException(String.format("Failed to calculate count entries. Query: '%s'. Error: ", selectCountQuery, countResult.errors()), countResult.info().errorCount());
                }
                result.setTotalEntriesCount(((N1qlQueryRow)countResult.allRows().get(0)).value().getInt("TOTAL").intValue());
            }
            catch (CouchbaseException ex) {
                throw new SearchException("Failed to calculate count entries. Query: '" + selectCountQuery.toString() + "'", (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public String[] createStoragePassword(String[] passwords) {
        if (ArrayHelper.isEmpty((Object[])passwords)) {
            return passwords;
        }
        String[] results = new String[passwords.length];
        for (int i = 0; i < passwords.length; ++i) {
            results[i] = PasswordEncryptionHelper.createStoragePassword((String)passwords[i], (PasswordEncryptionMethod)this.connectionProvider.getPasswordEncryptionMethod());
        }
        return results;
    }

    @Override
    public boolean isBinaryAttribute(String attribute) {
        return this.connectionProvider.isBinaryAttribute(attribute);
    }

    @Override
    public boolean isCertificateAttribute(String attribute) {
        return this.connectionProvider.isCertificateAttribute(attribute);
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.destory();
            }
            catch (Exception ex) {
                LOG.error("Failed to destory provider correctly");
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }
}

