/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.operation.impl;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.path.FromPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.gluu.persist.couchbase.model.BucketMapping;
import org.gluu.persist.exception.KeyConversionException;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.gluu.persist.operation.auth.PasswordEncryptionMethod;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);
    private Properties props;
    private String[] servers;
    private String[] buckets;
    private String defaultBucket;
    private String userName;
    private String userPassword;
    private CouchbaseEnvironment couchbaseEnvironment;
    private CouchbaseCluster cluster;
    private int creationResultCode;
    private HashMap<String, BucketMapping> bucketToBaseNameMapping;
    private HashMap<String, BucketMapping> baseNameToBucketMapping;
    private BucketMapping defaultBucketMapping;
    private ArrayList<String> binaryAttributes;
    private ArrayList<String> certificateAttributes;
    private PasswordEncryptionMethod passwordEncryptionMethod;

    protected CouchbaseConnectionProvider() {
    }

    public CouchbaseConnectionProvider(Properties props, CouchbaseEnvironment couchbaseEnvironment) {
        this.props = props;
        this.couchbaseEnvironment = couchbaseEnvironment;
    }

    public void create() {
        try {
            this.init();
        }
        catch (Exception ex) {
            this.creationResultCode = 1;
            Properties clonedProperties = (Properties)this.props.clone();
            if (clonedProperties.getProperty("auth.userName") != null) {
                clonedProperties.setProperty("auth.userPassword", "REDACTED");
            }
            LOG.error("Failed to create connection with properties: '{}'. Exception: {}", (Object)clonedProperties, (Object)ex);
        }
    }

    protected void init() {
        String[] binaryAttrs;
        this.servers = StringHelper.split((String)this.props.getProperty("servers"), (String)",");
        this.userName = this.props.getProperty("auth.userName");
        this.userPassword = this.props.getProperty("auth.userPassword");
        this.defaultBucket = this.props.getProperty("bucket.default");
        if (StringHelper.isEmpty((String)this.defaultBucket)) {
            throw new ConfigurationException("Default bucket is not defined!");
        }
        this.buckets = StringHelper.split((String)this.props.getProperty("buckets"), (String)",");
        if (!Arrays.asList(this.buckets).contains(this.defaultBucket)) {
            this.buckets = ArrayHelper.addItemToStringArray((String[])this.buckets, (String)this.defaultBucket);
        }
        this.bucketToBaseNameMapping = new HashMap();
        this.baseNameToBucketMapping = new HashMap();
        this.openWithWaitImpl();
        LOG.info("Opended: '{}' buket with base names: '{}'", this.bucketToBaseNameMapping.keySet(), this.baseNameToBucketMapping.keySet());
        this.passwordEncryptionMethod = this.props.containsKey("password.encryption.method") ? PasswordEncryptionMethod.getMethod((String)this.props.getProperty("password.encryption.method")) : PasswordEncryptionMethod.HASH_METHOD_SHA256;
        this.binaryAttributes = new ArrayList();
        if (this.props.containsKey("binaryAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("binaryAttributes").toString().toLowerCase(), (String)",");
            this.binaryAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary attributes: '{}'", this.binaryAttributes);
        this.certificateAttributes = new ArrayList();
        if (this.props.containsKey("certificateAttributes")) {
            binaryAttrs = StringHelper.split((String)this.props.get("certificateAttributes").toString().toLowerCase(), (String)",");
            this.certificateAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary certificateAttributes: '{}'", this.certificateAttributes);
        this.creationResultCode = 0;
    }

    private void openWithWaitImpl() {
        String connectionMaxWaitTime = this.props.getProperty("connection-max-wait-time");
        int connectionMaxWaitTimeSeconds = 30;
        if (StringHelper.isNotEmpty((String)connectionMaxWaitTime)) {
            connectionMaxWaitTimeSeconds = Integer.parseInt(connectionMaxWaitTime);
        }
        LOG.debug("Using Couchbase connection timeout: '{}'", (Object)connectionMaxWaitTimeSeconds);
        CouchbaseException lastException = null;
        int attempt = 0;
        long currentTime = System.currentTimeMillis();
        long maxWaitTime = currentTime + (long)(connectionMaxWaitTimeSeconds * 1000);
        while (true) {
            if (++attempt > 0) {
                LOG.info("Attempting to create connection: '{}'", (Object)attempt);
            }
            try {
                this.open();
            }
            catch (CouchbaseException ex) {
                lastException = ex;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    LOG.error("Exception happened in sleep", (Throwable)ex2);
                    return;
                }
                if (maxWaitTime > (currentTime = System.currentTimeMillis())) continue;
            }
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void open() {
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)this.couchbaseEnvironment, (String[])this.servers);
        this.cluster.authenticate(this.userName, this.userPassword);
        for (String bucketName : this.buckets) {
            String baseNamesProp = this.props.getProperty(String.format("bucket.%s.mapping", bucketName), "");
            String[] baseNames = StringHelper.split((String)baseNamesProp, (String)",");
            Bucket bucket = this.cluster.openBucket(bucketName);
            BucketMapping bucketMapping = new BucketMapping(bucketName, bucket);
            this.bucketToBaseNameMapping.put(bucketName, bucketMapping);
            for (String baseName : baseNames) {
                this.baseNameToBucketMapping.put(baseName, bucketMapping);
            }
            if (StringHelper.equalsIgnoreCase((String)bucketName, (String)this.defaultBucket)) {
                this.defaultBucketMapping = bucketMapping;
            }
            bucket.bucketManager().createN1qlPrimaryIndex(true, false);
        }
    }

    public boolean destory() {
        for (BucketMapping bucketMapping : this.bucketToBaseNameMapping.values()) {
            try {
                bucketMapping.getBucket().close();
            }
            catch (CouchbaseException ex) {
                LOG.error("Failed to close bucket '{}'", (Object)bucketMapping.getBucketName(), (Object)ex);
                return false;
            }
        }
        return this.cluster.disconnect();
    }

    public boolean isConnected() {
        if (this.cluster == null) {
            return false;
        }
        boolean isConnected = true;
        FromPath query = Select.select((String[])new String[]{"1"});
        for (BucketMapping bucketMapping : this.bucketToBaseNameMapping.values()) {
            try {
                Bucket bucket = bucketMapping.getBucket();
                if (!bucket.isClosed() && bucket.query((Statement)query).finalSuccess()) continue;
                LOG.error("Bucket '{}' is invalid", (Object)bucketMapping.getBucketName());
                isConnected = false;
                break;
            }
            catch (CouchbaseException ex) {
                LOG.error("Failed to check bucket", (Throwable)ex);
            }
        }
        return isConnected;
    }

    public BucketMapping getBucketMapping(String baseName) {
        BucketMapping bucketMapping = this.baseNameToBucketMapping.get(baseName);
        if (bucketMapping == null) {
            return null;
        }
        return bucketMapping;
    }

    public BucketMapping getBucketMappingByKey(String key) {
        if ("_".equals(key)) {
            return this.defaultBucketMapping;
        }
        Object[] baseNameParts = key.split("_");
        if (ArrayHelper.isEmpty((Object[])baseNameParts)) {
            throw new KeyConversionException("Failed to determine base key part!");
        }
        BucketMapping bucketMapping = this.baseNameToBucketMapping.get(baseNameParts[0]);
        if (bucketMapping == null) {
            return this.defaultBucketMapping;
        }
        return bucketMapping;
    }

    public int getCreationResultCode() {
        return this.creationResultCode;
    }

    public boolean isCreated() {
        return 0 == this.creationResultCode;
    }

    public String[] getServers() {
        return this.servers;
    }

    public ArrayList<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public ArrayList<String> getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public boolean isBinaryAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.binaryAttributes.contains(attributeName.toLowerCase());
    }

    public boolean isCertificateAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.certificateAttributes.contains(attributeName.toLowerCase());
    }

    public PasswordEncryptionMethod getPasswordEncryptionMethod() {
        return this.passwordEncryptionMethod;
    }

    public static void main(String[] args) {
        DefaultCouchbaseEnvironment.Builder builder = (DefaultCouchbaseEnvironment.Builder)DefaultCouchbaseEnvironment.builder().bootstrapHttpDirectPort(38091);
        DefaultCouchbaseEnvironment couchbaseEnvironment = builder.build();
        CouchbaseCluster cluster = CouchbaseCluster.create((CouchbaseEnvironment)couchbaseEnvironment, (String[])new String[]{"u164.gluu.info"});
        cluster.authenticate("admin", "secret");
        Bucket bucket = cluster.openBucket("gluu");
        System.out.println(bucket.exists("_"));
    }
}

