/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.impl;

import com.couchbase.client.java.query.dsl.Expression;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.search.filter.Filter;
import org.gluu.search.filter.FilterType;

public class CouchbaseFilterConverter {
    public Expression convertToLdapFilter(Filter genericFilter) throws SearchException {
        FilterType type = genericFilter.getType();
        if (FilterType.RAW == type) {
            throw new SearchException("Convertion from RAW Ldap filter to couchbasefilter is not implemented");
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = genericFilter.getFilters();
            Expression[] expFilters = new Expression[genericFilters.length];
            if (genericFilters != null) {
                for (int i = 0; i < genericFilters.length; ++i) {
                    expFilters[i] = this.convertToLdapFilter(genericFilters[i]);
                }
                if (FilterType.NOT == type) {
                    return Expression.par((Expression)expFilters[0].not());
                }
                if (FilterType.AND == type) {
                    Expression result = expFilters[0];
                    for (int i = 1; i < expFilters.length; ++i) {
                        result = result.and(expFilters[i]);
                    }
                    return Expression.par((Expression)result);
                }
                if (FilterType.OR == type) {
                    Expression result = expFilters[0];
                    for (int i = 1; i < expFilters.length; ++i) {
                        result = result.or(expFilters[i]);
                    }
                    return Expression.par((Expression)result);
                }
            }
        }
        if (FilterType.EQUALITY == type) {
            if (genericFilter.isArrayAttribute()) {
                return Expression.path((Object[])new Object[]{Expression.s((String[])new String[]{genericFilter.getAssertionValue()}).in(Expression.path((Object[])new Object[]{genericFilter.getAttributeName()}))});
            }
            Expression exp1 = Expression.par((Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{genericFilter.getAttributeName()})}).eq(Expression.s((String[])new String[]{genericFilter.getAssertionValue()})));
            Expression exp2 = Expression.par((Expression)Expression.path((Object[])new Object[]{Expression.s((String[])new String[]{genericFilter.getAssertionValue()})}).in(Expression.path((Object[])new Object[]{genericFilter.getAttributeName()})));
            return Expression.par((Expression)exp1.or(exp2));
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            return Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{genericFilter.getAttributeName()})}).lte(Expression.s((String[])new String[]{genericFilter.getAssertionValue()}));
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            return Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{genericFilter.getAttributeName()})}).gte(Expression.s((String[])new String[]{genericFilter.getAssertionValue()}));
        }
        if (FilterType.PRESENCE == type) {
            return Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{genericFilter.getAttributeName()})}).exists();
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to Couchbase filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            StringBuilder like = new StringBuilder();
            if (genericFilter.getSubInitial() != null) {
                like.append(genericFilter.getSubInitial());
            }
            like.append("%");
            String[] subAny = genericFilter.getSubAny();
            if (subAny != null && subAny.length > 0) {
                for (String any : subAny) {
                    like.append(any);
                    like.append("%");
                }
            }
            if (genericFilter.getSubFinal() != null) {
                like.append(genericFilter.getSubFinal());
            }
            return Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{genericFilter.getAttributeName()}).like(Expression.s((String[])new String[]{like.toString()}))});
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }
}

