/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.impl;

import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.couchbase.impl.CouchbaseEntryManager;
import org.gluu.persist.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.persist.couchbase.operation.impl.CouchbaseOperationsServiceImpl;
import org.gluu.persist.exception.operation.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CouchbaseEntryManagerFactory
implements PersistenceEntryManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseEntryManagerFactory.class);
    private CouchbaseEnvironment couchbaseEnvironment;

    @PostConstruct
    public void create() {
        this.couchbaseEnvironment = DefaultCouchbaseEnvironment.create();
    }

    public String getPersistenceType() {
        return "couchbase";
    }

    public String getDefaultConfigurationFileName() {
        return "gluu-couchbase.properties";
    }

    public CouchbaseEntryManager createEntryManager(Properties conf) {
        CouchbaseConnectionProvider connectionProvider = new CouchbaseConnectionProvider(conf, this.couchbaseEnvironment);
        connectionProvider.create();
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create Couchbase connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        CouchbaseEntryManager couchbaseEntryManager = new CouchbaseEntryManager(new CouchbaseOperationsServiceImpl(connectionProvider));
        LOG.info("Created CouchbaseEntryManager: {}", (Object)couchbaseEntryManager.getOperationService());
        return couchbaseEntryManager;
    }
}

