/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.impl;

import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.subdoc.MutationSpec;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gluu.persist.couchbase.impl.CouchbaseBatchOperationWraper;
import org.gluu.persist.couchbase.impl.CouchbaseFilterConverter;
import org.gluu.persist.couchbase.impl.CouchbaseKeyConverter;
import org.gluu.persist.couchbase.model.ParsedKey;
import org.gluu.persist.couchbase.model.SearchReturnDataType;
import org.gluu.persist.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.persist.couchbase.operation.impl.CouchbaseOperationsServiceImpl;
import org.gluu.persist.event.DeleteNotifier;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.exception.MappingException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.impl.BaseEntryManager;
import org.gluu.persist.model.AttributeData;
import org.gluu.persist.model.AttributeDataModification;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.DefaultBatchOperation;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.SortOrder;
import org.gluu.persist.reflect.property.PropertyAnnotation;
import org.gluu.search.filter.Filter;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseEntryManager
extends BaseEntryManager
implements Serializable {
    private static final long serialVersionUID = 2127241817126412574L;
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);
    private static final CouchbaseFilterConverter FILTER_CONVERTER = new CouchbaseFilterConverter();
    private static final CouchbaseKeyConverter KEY_CONVERTER = new CouchbaseKeyConverter();
    private SimpleDateFormat jsonDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private CouchbaseOperationsServiceImpl operationService;
    private List<DeleteNotifier> subscribers;

    protected CouchbaseEntryManager(CouchbaseOperationsServiceImpl operationService) {
        this.operationService = operationService;
        this.subscribers = new LinkedList<DeleteNotifier>();
    }

    public boolean destroy() {
        if (this.operationService == null) {
            return true;
        }
        return this.operationService.destroy();
    }

    public CouchbaseOperationsServiceImpl getOperationService() {
        return this.operationService;
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.remove(subscriber);
    }

    public <T> T merge(T entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isLdapSchemaEntry(entryClass)) {
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        return (T)this.merge(entry, false, null);
    }

    protected <T> void updateMergeChanges(T entry, boolean isSchemaUpdate, Class<?> entryClass, Map<String, AttributeData> attributesFromDbMap, List<AttributeDataModification> attributeDataModifications) {
        if (!isSchemaUpdate) {
            Object[] objectClasses = this.getObjectClasses(entry, entryClass);
            AttributeData objectClassAttributeData = attributesFromDbMap.get("objectClass".toLowerCase());
            if (objectClassAttributeData == null) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses list! Entry is invalid: '%s'", entry));
            }
            Object[] objectClassesFromDb = objectClassAttributeData.getValues();
            if (!Arrays.equals(objectClassesFromDb, objectClasses)) {
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, new AttributeData("objectClass", (String[])objectClasses), new AttributeData("objectClass", (String[])objectClassesFromDb)));
            }
        }
    }

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isLdapSchemaEntry(entryClass)) {
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        Object dnValue = this.getDNValue(entry, entryClass);
        LOG.debug("LDAP entry to remove: '{}'", (Object)dnValue.toString());
        this.remove(dnValue.toString());
    }

    protected void persist(String dn, List<AttributeData> attributes) {
        JsonObject jsonObject = JsonObject.create();
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            Object[] attributeValues = attribute.getValues();
            if (!ArrayHelper.isNotEmpty((Object[])attributeValues) || !StringHelper.isNotEmpty((String)attributeValues[0])) continue;
            Object[] realValues = attributeValues;
            if (StringHelper.equals((String)"userPassword", (String)attributeName)) {
                realValues = this.operationService.createStoragePassword((String[])attributeValues);
            }
            if (realValues.length > 1) {
                jsonObject.put(attributeName, JsonArray.from((Object[])realValues));
                continue;
            }
            jsonObject.put(attributeName, (String)realValues[0]);
        }
        jsonObject.put("dn", dn);
        try {
            boolean result = this.operationService.addEntry(this.toCouchbaseKey(dn).getKey(), jsonObject);
            if (!result) {
                throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), (Throwable)ex);
        }
    }

    public void merge(String dn, List<AttributeDataModification> attributeDataModifications) {
        try {
            boolean result;
            ArrayList<MutationSpec> modifications = new ArrayList<MutationSpec>(attributeDataModifications.size());
            for (AttributeDataModification attributeDataModification : attributeDataModifications) {
                AttributeData attribute = attributeDataModification.getAttribute();
                AttributeData oldAttribute = attributeDataModification.getOldAttribute();
                String attributeName = null;
                String[] attributeValues = null;
                if (attribute != null) {
                    attributeName = attribute.getName();
                    attributeValues = attribute.getValues();
                }
                String oldAttributeName = null;
                String[] oldAttributeValues = null;
                if (oldAttribute != null) {
                    oldAttributeName = oldAttribute.getName();
                    oldAttributeValues = oldAttribute.getValues();
                }
                MutationSpec modification = null;
                if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(Mutation.DICT_ADD, attributeName, attributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REMOVE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(Mutation.DELETE, oldAttributeName, oldAttributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REPLACE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(Mutation.REPLACE, attributeName, attributeValues);
                }
                if (modification == null) continue;
                modifications.add(modification);
            }
            if (modifications.size() > 0 && !(result = this.operationService.updateEntry(this.toCouchbaseKey(dn).getKey(), modifications))) {
                throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), (Throwable)ex);
        }
    }

    protected void remove(String dn) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn);
            }
            this.operationService.delete(this.toCouchbaseKey(dn).getKey());
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    public void removeRecursively(String dn) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn);
            }
            this.operationService.deleteRecursively(this.toCouchbaseKey(dn).getKey());
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    protected List<AttributeData> find(String dn, String ... ldapReturnAttributes) {
        try {
            ParsedKey keyWithInum = this.toCouchbaseKey(dn);
            JsonObject entry = this.operationService.lookup(keyWithInum.getKey(), ldapReturnAttributes);
            List<AttributeData> result = this.getAttributeDataList(entry);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), (Throwable)ex);
        }
        throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn));
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        PagedResult<JsonObject> searchResult = this.findEntriesImpl(baseDN, entryClass, filter, scope, ldapReturnAttributes, null, null, batchOperation, SearchReturnDataType.SEARCH, start, count, chunkSize);
        if (searchResult.getEntriesCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntities(baseDN, entryClass, searchResult);
        return entries;
    }

    public <T> PagedResult<T> findPagedEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        PagedResult<JsonObject> searchResult = this.findEntriesImpl(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, sortBy, sortOrder, null, SearchReturnDataType.SEARCH_COUNT, start, count, chunkSize);
        PagedResult result = new PagedResult();
        result.setEntriesCount(searchResult.getEntriesCount());
        result.setStart(searchResult.getStart());
        result.setTotalEntriesCount(searchResult.getTotalEntriesCount());
        if (searchResult.getEntriesCount() == 0) {
            result.setEntries(new ArrayList(0));
            return result;
        }
        List<T> entries = this.createEntities(baseDN, entryClass, searchResult);
        result.setEntries(entries);
        return result;
    }

    protected <T> PagedResult<JsonObject> findEntriesImpl(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, BatchOperation<T> batchOperation, SearchReturnDataType returnDataType, int start, int count, int chunkSize) {
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getLdapAttributes(null, propertiesAnnotations, false);
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        Object[] defaultSort = this.getDefaultSort(entryClass);
        if (StringHelper.isNotEmpty((String)sortBy)) {
            Sort requestedSort = this.buildSort(sortBy, sortOrder);
            defaultSort = ArrayHelper.isEmpty((Object[])defaultSort) ? new Sort[]{requestedSort} : (Sort[])ArrayHelper.arrayMerge((Object[][])new Sort[][]{{requestedSort}, defaultSort});
        }
        PagedResult<JsonObject> searchResult = null;
        try {
            ParsedKey keyWithInum;
            CouchbaseBatchOperationWraper<T> batchOperationWraper = null;
            if (batchOperation != null) {
                batchOperationWraper = new CouchbaseBatchOperationWraper<T>(batchOperation, this, entryClass, propertiesAnnotations);
            }
            if ((searchResult = this.operationService.search((keyWithInum = this.toCouchbaseKey(baseDN)).getKey(), this.toCouchbaseFilter(searchFilter), scope, (String[])currentLdapReturnAttributes, (Sort[])defaultSort, batchOperationWraper, returnDataType, start, count, chunkSize)) == null) {
                throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
            return searchResult;
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
    }

    protected boolean contains(String baseDN, Filter filter, String[] objectClasses, String[] ldapReturnAttributes) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to check contain entries is null");
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        PagedResult<JsonObject> searchResult = null;
        try {
            ParsedKey keyWithInum = this.toCouchbaseKey(baseDN);
            searchResult = this.operationService.search(keyWithInum.getKey(), this.toCouchbaseFilter(searchFilter), SearchScope.SUB, ldapReturnAttributes, null, null, SearchReturnDataType.SEARCH, 1, 1, 0);
            if (searchResult == null) {
                throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        return searchResult != null && searchResult.getEntriesCount() > 0;
    }

    protected <T> List<T> createEntities(String baseDN, Class<T> entryClass, PagedResult<JsonObject> searchResult) {
        ParsedKey keyWithInum = this.toCouchbaseKey(baseDN);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        List<T> entries = this.createEntities(entryClass, propertiesAnnotations, keyWithInum, searchResult.getEntries().toArray(new JsonObject[searchResult.getEntriesCount()]));
        return entries;
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, ParsedKey baseDn, JsonObject ... searchResultEntries) {
        ArrayList result = new ArrayList(searchResultEntries.length);
        LinkedHashMap<String, List<AttributeData>> entriesAttributes = new LinkedHashMap<String, List<AttributeData>>(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            ++count;
            JsonObject entry = searchResultEntries[i];
            String dn = entry.getString("dn");
            entriesAttributes.put(dn, this.getAttributeDataList(entry));
            searchResultEntries[i] = null;
            if (count < 100) continue;
            List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
            result.addAll(currentResult);
            entriesAttributes = new LinkedHashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        result.addAll(currentResult);
        return result;
    }

    private List<AttributeData> getAttributeDataList(JsonObject entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<AttributeData> result = new ArrayList<AttributeData>();
        for (String attributeName : entry.getNames()) {
            Object attributeObject = entry.get(attributeName);
            if (attributeObject == null) {
                String[] stringArray = NO_STRINGS;
            }
            String[] attributeValueStrings = attributeObject instanceof JsonArray ? ((JsonArray)attributeObject).toList().toArray(NO_STRINGS) : new String[]{attributeObject.toString()};
            AttributeData tmpAttribute = new AttributeData(attributeName, attributeValueStrings);
            result.add(tmpAttribute);
        }
        return result;
    }

    public boolean authenticate(String baseDN, String userName, String password) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"uid", (String)userName);
            PagedResult<JsonObject> searchResult = this.operationService.search(this.toCouchbaseKey(baseDN).getKey(), this.toCouchbaseFilter(filter), SearchScope.SUB, null, null, null, SearchReturnDataType.SEARCH, 0, 1, 1);
            if (searchResult == null || searchResult.getEntriesCount() != 1) {
                return false;
            }
            String bindDn = ((JsonObject)searchResult.getEntries().get(0)).getString("dn");
            return this.authenticate(bindDn, password);
        }
        catch (SearchException ex) {
            throw new AuthenticationException(String.format("Failed to find user DN: %s", userName), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate user: %s", userName), (Throwable)ex);
        }
    }

    public boolean authenticate(String bindDn, String password) {
        try {
            return this.operationService.authenticate(this.toCouchbaseKey(bindDn).getKey(), password);
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate DN: %s", bindDn), (Throwable)ex);
        }
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        return this.countEntries(baseDN, entryClass, filter, SearchScope.SUB);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope) {
        PagedResult<JsonObject> searchResult;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        try {
            searchResult = this.operationService.search(this.toCouchbaseKey(baseDN).getKey(), this.toCouchbaseFilter(searchFilter), scope, null, null, null, SearchReturnDataType.COUNT, 0, 0, 0);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to calucalte count of entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        return searchResult.getTotalEntriesCount();
    }

    private MutationSpec createModification(Mutation type, String attributeName, String ... attributeValues) {
        String realAttributeName = attributeName;
        String[] realValues = attributeValues;
        if (StringHelper.equals((String)"userPassword", (String)realAttributeName)) {
            realValues = this.operationService.createStoragePassword(attributeValues);
        }
        if (realValues.length == 1) {
            return new MutationSpec(type, realAttributeName, (Object)realValues[0]);
        }
        return new MutationSpec(type, realAttributeName, (Object)realValues);
    }

    protected Sort buildSort(String sortBy, SortOrder sortOrder) {
        Sort requestedSort = null;
        requestedSort = SortOrder.DESCENDING == sortOrder ? Sort.desc((Expression)Expression.path((Object[])new Object[]{sortBy})) : (SortOrder.ASCENDING == sortOrder ? Sort.asc((Expression)Expression.path((Object[])new Object[]{sortBy})) : Sort.def((Expression)Expression.path((Object[])new Object[]{sortBy})));
        return requestedSort;
    }

    protected <T> Sort[] getDefaultSort(Class<T> entryClass) {
        Object[] sortByProperties = this.getEntrySortBy(entryClass);
        if (ArrayHelper.isEmpty((Object[])sortByProperties)) {
            return null;
        }
        Sort[] sort = new Sort[sortByProperties.length];
        for (int i = 0; i < sortByProperties.length; ++i) {
            sort[i] = Sort.def((Expression)Expression.path((Object[])new Object[]{sortByProperties[i]}));
        }
        return sort;
    }

    public String[] exportEntry(String dn) {
        try {
            ParsedKey keyWithInum = this.toCouchbaseKey(dn);
            JsonObject entry = this.operationService.lookup(keyWithInum.getKey(), new String[0]);
            Map map = entry.toMap();
            ArrayList<String> result = new ArrayList<String>(map.size());
            for (Map.Entry attr : map.entrySet()) {
                result.add((String)attr.getKey() + ": " + attr.getValue());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), (Throwable)ex);
        }
    }

    private Expression toCouchbaseFilter(Filter genericFilter) throws SearchException {
        return FILTER_CONVERTER.convertToLdapFilter(genericFilter);
    }

    private ParsedKey toCouchbaseKey(String dn) {
        return KEY_CONVERTER.convertToKey(dn);
    }

    public String encodeTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.jsonDateFormat.format(date);
    }

    public Date decodeTime(String date) {
        Date decodedDate;
        if (StringHelper.isEmpty((String)date)) {
            return null;
        }
        try {
            decodedDate = this.jsonDateFormat.parse(date);
        }
        catch (ParseException ex) {
            LOG.error("Failed to decode generalized time '{}'", (Object)date, (Object)ex);
            return null;
        }
        return decodedDate;
    }

    public boolean hasBranchesSupport(String dn) {
        return false;
    }

    private static final class CountBatchOperation<T>
    extends DefaultBatchOperation<T> {
        private int countEntries = 0;

        private CountBatchOperation() {
        }

        public void performAction(List<T> entries) {
        }

        public boolean collectSearchResult(int size) {
            this.countEntries += size;
            return false;
        }

        public int getCountEntries() {
            return this.countEntries;
        }
    }
}

