/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.couchbase;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.gluu.couchbase.CouchbaseSampleEntryManager;
import org.gluu.couchbase.model.SimpleSessionState;
import org.gluu.log.LoggingHelper;
import org.gluu.persist.couchbase.impl.CouchbaseEntryManager;

public final class CouchbaseSampleSimpleSessionSample {
    private static final Logger LOG;

    private CouchbaseSampleSimpleSessionSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        CouchbaseSampleEntryManager couchbaseSampleEntryManager = new CouchbaseSampleEntryManager();
        final CouchbaseEntryManager couchbaseEntryManager = couchbaseSampleEntryManager.createCouchbaseEntryManager();
        try {
            String sessionId = "xyzcyzxy-a41a-45ad-8a83-61485dbad561";
            final String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163,o=gluu";
            String userDn = "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163,o=gluu";
            SimpleSessionState simpleSessionState = new SimpleSessionState();
            simpleSessionState.setDn(sessionDn);
            simpleSessionState.setId(sessionId);
            simpleSessionState.setLastUsedAt(new Date());
            couchbaseEntryManager.persist((Object)simpleSessionState);
            System.out.println("Persisted");
            int threadCount = 500;
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, CouchbaseSampleSimpleSessionSample.daemonThreadFactory());
            int i = 0;
            while (i < threadCount) {
                final int count = i++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleSessionState simpleSessionStateFromCouchbase = (SimpleSessionState)couchbaseEntryManager.find(SimpleSessionState.class, (Object)sessionDn);
                        String beforeUserDn = simpleSessionStateFromCouchbase.getUserDn();
                        String randomUserDn = count % 2 == 0 ? "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163,o=gluu" : "";
                        try {
                            simpleSessionStateFromCouchbase.setUserDn(randomUserDn);
                            simpleSessionStateFromCouchbase.setLastUsedAt(new Date());
                            couchbaseEntryManager.merge((Object)simpleSessionStateFromCouchbase);
                            System.out.println("Merged thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn);
                        }
                        catch (Throwable e) {
                            System.out.println("ERROR !!!, thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn + ", error:" + e.getMessage());
                        }
                    }
                });
            }
            Thread.sleep(5000L);
        }
        finally {
            couchbaseEntryManager.destroy();
        }
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(CouchbaseSampleSimpleSessionSample.class);
    }
}

