/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.couchbase;

import java.util.Arrays;
import java.util.List;
import org.gluu.couchbase.CouchbaseSampleEntryManager;
import org.gluu.couchbase.model.SimpleAttribute;
import org.gluu.couchbase.model.SimpleGrant;
import org.gluu.couchbase.model.SimpleSession;
import org.gluu.couchbase.model.SimpleUser;
import org.gluu.persist.couchbase.impl.CouchbaseEntryManager;
import org.gluu.persist.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.SortOrder;
import org.gluu.persist.model.base.CustomAttribute;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseSample() {
    }

    public static void main(String[] args) {
        PagedResult listViewResponse;
        CouchbaseSampleEntryManager couchbaseSampleEntryManager = new CouchbaseSampleEntryManager();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseSampleEntryManager.createCouchbaseEntryManager();
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=@!5304.5F36.0E64.E1AC!0001!179C.62D7,o=gluu", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomAttribute("streetAddress", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomAttribute("test", "test_value"));
        couchbaseEntryManager.persist((Object)newUser);
        List users = couchbaseEntryManager.findEntries("o=@!5304.5F36.0E64.E1AC!0001!179C.62D7,o=gluu", SimpleUser.class, null);
        for (SimpleUser user : users) {
            LOG.info("User with uid: '{}' with DN: '{}'", (Object)user.getUserId(), (Object)user.getDn());
        }
        if (users.size() > 0) {
            SimpleUser user = (SimpleUser)users.get(3);
            LOG.info("Updating: " + user.getUserId());
            String[] values = new String[]{"Somewhere: " + System.currentTimeMillis(), "Somewhere2: " + System.currentTimeMillis()};
            user.getCustomAttributes().add(new CustomAttribute("streetAddress", Arrays.asList(values)));
            user.getCustomAttributes().add(new CustomAttribute("test", "test_value"));
            user.getCustomAttributes().add(new CustomAttribute("test2", "test_value2"));
            user.getCustomAttributes().add(new CustomAttribute("test3", "test_value3"));
            user.setUserId("user1");
            user.setUserPassword("test");
            couchbaseEntryManager.merge((Object)user);
        }
        for (SimpleUser user : users) {
            boolean result1 = couchbaseEntryManager.authenticate(user.getDn(), "test");
            boolean result2 = couchbaseEntryManager.authenticate("ou=people,o=@!5304.5F36.0E64.E1AC!0001!179C.62D7,o=gluu", user.getUserId(), "test");
            System.out.println("authetication result: " + result1 + ", " + result2);
        }
        Filter filter = Filter.createEqualityFilter((String)"gluuStatus", (String)"active");
        List attributes = couchbaseEntryManager.findEntries("o=gluu", SimpleAttribute.class, filter, SearchScope.SUB, null, null, 10, 0, 0);
        for (SimpleAttribute attribute : attributes) {
            LOG.info("Attribute with displayName: " + attribute.getCustomAttributes().get(1));
        }
        List sessions = couchbaseEntryManager.findEntries("o=gluu", SimpleSession.class, filter, SearchScope.SUB, null, null, 10, 0, 0);
        LOG.info("Found sessions: " + sessions.size());
        List grants = couchbaseEntryManager.findEntries("o=gluu", SimpleGrant.class, null, SearchScope.SUB, new String[]{"oxAuthGrantId"}, null, 1, 0, 0);
        LOG.info("Found grants: " + grants.size());
        try {
            listViewResponse = couchbaseEntryManager.findPagedEntries("o=gluu", SimpleUser.class, null, new String[]{"uid", "displayName", "gluuStatus"}, "uid", SortOrder.ASCENDING, 0, 6, 4);
            LOG.info("Found persons: " + listViewResponse.getEntriesCount() + ", total persons: " + listViewResponse.getTotalEntriesCount());
            for (SimpleUser user : listViewResponse.getEntries()) {
                System.out.println(user.getUserId());
            }
        }
        catch (Exception ex) {
            LOG.info("Failed to search", (Throwable)ex);
        }
        try {
            listViewResponse = couchbaseEntryManager.findPagedEntries("o=gluu", SimpleUser.class, null, new String[]{"uid", "displayName", "gluuStatus"}, "uid", SortOrder.DESCENDING, 0, 6, 4);
            LOG.info("Found persons: " + listViewResponse.getEntriesCount() + ", total persons: " + listViewResponse.getTotalEntriesCount());
            for (SimpleUser user : listViewResponse.getEntries()) {
                System.out.println(user.getUserId());
            }
        }
        catch (Exception ex) {
            LOG.info("Failed to search", (Throwable)ex);
        }
    }
}

