/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.couchbase.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gluu.persist.model.base.CustomAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.util.StringHelper;

@LdapEntry
@LdapObjectClass(values={"gluuAttribute", "top"})
public class SimpleAttribute
implements Serializable {
    private static final long serialVersionUID = -1634191420188575733L;
    @LdapDN
    private String dn;
    @LdapAttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @LdapCustomObjectClass
    private String[] customObjectClasses;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String ldapAttribute) {
        String attribute = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(ldapAttribute)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String ldapAttribute) {
        List values = null;
        if (ldapAttribute != null && !ldapAttribute.isEmpty()) {
            for (CustomAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)ldapAttribute)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

