/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.couchbase;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.gluu.couchbase.CouchbaseSample;
import org.gluu.couchbase.CouchbaseSampleEntryManager;
import org.gluu.couchbase.model.SimpleClient;
import org.gluu.couchbase.model.SimpleSession;
import org.gluu.couchbase.model.SimpleTokenCouchbase;
import org.gluu.persist.couchbase.impl.CouchbaseEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.DefaultBatchOperation;
import org.gluu.persist.model.ProcessBatchOperation;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.base.CustomAttribute;
import org.gluu.search.filter.Filter;
import org.xdi.log.LoggingHelper;

public final class CouchbaseSampleBatchJob {
    private static final Logger LOG;

    private CouchbaseSampleBatchJob() {
    }

    public static void main(String[] args) {
        CouchbaseSampleEntryManager couchbaseSampleEntryManager = new CouchbaseSampleEntryManager();
        final CouchbaseEntryManager couchbaseEntryManager = couchbaseSampleEntryManager.createCouchbaseEntryManager();
        ProcessBatchOperation<SimpleTokenCouchbase> tokenCouchbaseBatchOperation = new ProcessBatchOperation<SimpleTokenCouchbase>(){
            private int processedCount = 0;

            public void performAction(List<SimpleTokenCouchbase> objects) {
                for (SimpleTokenCouchbase simpleTokenCouchbase : objects) {
                    try {
                        CustomAttribute customAttribute = CouchbaseSampleBatchJob.getUpdatedAttribute(couchbaseEntryManager, "oxAuthExpiration", simpleTokenCouchbase.getAttribute("oxAuthExpiration"));
                        simpleTokenCouchbase.setCustomAttributes(Arrays.asList(customAttribute));
                        couchbaseEntryManager.merge((Object)simpleTokenCouchbase);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter1 = Filter.createPresenceFilter((String)"oxAuthExpiration");
        couchbaseEntryManager.findEntries("o=gluu", SimpleTokenCouchbase.class, filter1, SearchScope.SUB, new String[]{"oxAuthExpiration"}, (BatchOperation)tokenCouchbaseBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleSession> sessionBatchOperation = new ProcessBatchOperation<SimpleSession>(){
            private int processedCount = 0;

            public void performAction(List<SimpleSession> objects) {
                for (SimpleSession simpleSession : objects) {
                    try {
                        CustomAttribute customAttribute = CouchbaseSampleBatchJob.getUpdatedAttribute(couchbaseEntryManager, "oxLastAccessTime", simpleSession.getAttribute("oxLastAccessTime"));
                        simpleSession.setCustomAttributes(Arrays.asList(customAttribute));
                        couchbaseEntryManager.merge((Object)simpleSession);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter2 = Filter.createPresenceFilter((String)"oxLastAccessTime");
        couchbaseEntryManager.findEntries("o=gluu", SimpleSession.class, filter2, SearchScope.SUB, new String[]{"oxLastAccessTime"}, (BatchOperation)sessionBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleClient> clientBatchOperation = new ProcessBatchOperation<SimpleClient>(){
            private int processedCount = 0;

            public void performAction(List<SimpleClient> objects) {
                for (SimpleClient simpleClient : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter3 = Filter.createPresenceFilter((String)"oxAuthClientSecretExpiresAt");
        List result3 = couchbaseEntryManager.findEntries("o=gluu", SimpleClient.class, filter3, SearchScope.SUB, new String[]{"oxAuthClientSecretExpiresAt"}, (BatchOperation)clientBatchOperation, 0, 0, 1000);
        LOG.info((Object)("Result count (without collecting results): " + result3.size()));
        DefaultBatchOperation<SimpleClient> clientBatchOperation2 = new DefaultBatchOperation<SimpleClient>(){
            private int processedCount = 0;

            public void performAction(List<SimpleClient> objects) {
                for (SimpleClient simpleClient : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter4 = Filter.createPresenceFilter((String)"oxAuthClientSecretExpiresAt");
        List result4 = couchbaseEntryManager.findEntries("o=gluu", SimpleClient.class, filter4, SearchScope.SUB, new String[]{"oxAuthClientSecretExpiresAt"}, (BatchOperation)clientBatchOperation2, 0, 0, 1000);
        LOG.info((Object)("Result count (with collecting results): " + result4.size()));
    }

    private static CustomAttribute getUpdatedAttribute(CouchbaseEntryManager couchbaseEntryManager, String attributeName, String attributeValue) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date oxLastAccessTimeDate = new Date();
            calendar.setTime(oxLastAccessTimeDate);
            calendar.add(13, -1);
            CustomAttribute customAttribute = new CustomAttribute();
            customAttribute.setName(attributeName);
            customAttribute.setValue(couchbaseEntryManager.encodeGeneralizedTime(calendar.getTime()));
            return customAttribute;
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't parse attribute", (Throwable)ex);
            return null;
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(CouchbaseSample.class);
    }
}

