/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import java.io.File;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.gluu.service.cache.AbstractRedisProvider;
import org.gluu.service.cache.RedisClusterProvider;
import org.gluu.service.cache.RedisConfiguration;
import org.gluu.service.cache.RedisProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisStandaloneProvider
extends AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStandaloneProvider.class);
    private JedisPool pool;

    public RedisStandaloneProvider(RedisConfiguration redisConfiguratio) {
        super(redisConfiguratio);
    }

    @Override
    public void create() {
        LOG.debug("Starting RedisStandaloneProvider ...");
        try {
            JedisPoolConfig poolConfig = this.createPoolConfig();
            HostAndPort hostAndPort = RedisClusterProvider.hosts(this.redisConfiguration.getServers()).iterator().next();
            String password = this.redisConfiguration.getPassword();
            this.pool = this.redisConfiguration.getUseSSL().booleanValue() ? (StringUtils.isNotBlank((String)this.redisConfiguration.getSslTrustStoreFilePath()) ? (StringUtils.isBlank((String)password) ? new JedisPool((GenericObjectPoolConfig)poolConfig, hostAndPort.getHost(), hostAndPort.getPort(), true, RedisProviderFactory.createTrustStoreSslSocketFactory(new File(this.redisConfiguration.getSslTrustStoreFilePath())), new SSLParameters(), (HostnameVerifier)new DefaultHostnameVerifier()) : new JedisPool((GenericObjectPoolConfig)poolConfig, hostAndPort.getHost(), hostAndPort.getPort(), this.redisConfiguration.getConnectionTimeout(), password, true, RedisProviderFactory.createTrustStoreSslSocketFactory(new File(this.redisConfiguration.getSslTrustStoreFilePath())), new SSLParameters(), (HostnameVerifier)new DefaultHostnameVerifier())) : (StringUtils.isBlank((String)password) ? new JedisPool((GenericObjectPoolConfig)poolConfig, hostAndPort.getHost(), hostAndPort.getPort(), true) : new JedisPool((GenericObjectPoolConfig)poolConfig, hostAndPort.getHost(), hostAndPort.getPort(), this.redisConfiguration.getConnectionTimeout(), password, true))) : new JedisPool((GenericObjectPoolConfig)poolConfig, hostAndPort.getHost(), hostAndPort.getPort(), this.redisConfiguration.getConnectionTimeout(), password);
            this.testConnection();
            LOG.debug("RedisStandaloneProvider started.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting RedisStandaloneProvider", e);
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        LOG.debug("Destroying RedisStandaloneProvider");
        this.pool.close();
        LOG.debug("Destroyed RedisStandaloneProvider");
    }

    public JedisPool getDelegate() {
        return this.pool;
    }

    @Override
    public boolean hasKey(String key) {
        Boolean hasKey = this.pool.getResource().exists(key);
        return Boolean.TRUE.equals(hasKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        try (Jedis jedis = this.pool.getResource();){
            byte[] value = jedis.get(key.getBytes());
            Object deserialized = null;
            if (value != null && value.length > 0) {
                deserialized = SerializationUtils.deserialize((byte[])value);
            }
            Object object = deserialized;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        try (Jedis jedis = this.pool.getResource();){
            String status = jedis.setex(key.getBytes(), expirationInSeconds, SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object object) {
        try (Jedis jedis = this.pool.getResource();){
            String status = jedis.set(key.getBytes(), SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        try (Jedis jedis = this.pool.getResource();){
            Long entriesRemoved = jedis.del(key.getBytes());
            LOG.trace("remove - key: " + key + ", entriesRemoved: " + entriesRemoved);
        }
    }

    @Override
    public void clear() {
        try (Jedis jedis = this.pool.getResource();){
            jedis.flushAll();
            LOG.trace("clear");
        }
    }
}

