/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.TokenRequest;
import org.gluu.oxauth.model.common.AuthenticationMethod;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.crypto.AbstractCryptoProvider;
import org.gluu.oxauth.model.crypto.OxAuthCryptoProvider;
import org.gluu.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class TokenRestWebServiceWithHSAlgEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId1;
    private static String clientSecret1;
    private static String clientId2;
    private static String clientSecret2;
    private static String clientId3;
    private static String clientSecret3;

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtHS256Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithHSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtHS256Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtHS256Step1"})
    public void requestAccessTokenWithClientSecretJwtHS256Step2(String tokenPath, String userId, String userSecret, String audience) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId1);
        tokenRequest.setAuthPassword(clientSecret1);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithHSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtHS256Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtHS384Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithHSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtHS384Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId2 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret2 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtHS384Step1"})
    public void requestAccessTokenWithClientSecretJwtHS384Step2(String tokenPath, String userId, String userSecret, String audience) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId2);
        tokenRequest.setAuthPassword(clientSecret2);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS384);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithHSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtHS384Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "clientJwksUri"})
    @Test
    public void requestAccessTokenWithClientSecretJwtHS512Step1(String registerPath, String redirectUris, String jwksUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        List<GrantType> grantTypes = Arrays.asList(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        registerRequest.setGrantTypes(grantTypes);
        String registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        Response response = request.post(Entity.json((Object)registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithHSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtHS512Step1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            clientId3 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
            clientSecret3 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"tokenPath", "userId", "userSecret", "audience"})
    @Test(dependsOnMethods={"requestAccessTokenWithClientSecretJwtHS512Step1"})
    public void requestAccessTokenWithClientSecretJwtHS512Step2(String tokenPath, String userId, String userSecret, String audience) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + tokenPath).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        OxAuthCryptoProvider cryptoProvider = new OxAuthCryptoProvider();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setUsername(userId);
        tokenRequest.setPassword(userSecret);
        tokenRequest.setScope("email read_stream manage_pages");
        tokenRequest.setAuthUsername(clientId3);
        tokenRequest.setAuthPassword(clientSecret3);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
        tokenRequest.setAlgorithm(SignatureAlgorithm.HS512);
        tokenRequest.setAudience(audience);
        Response response = request.post(Entity.form((MultivaluedMap)new MultivaluedHashMap(tokenRequest.getParameters())));
        String entity = (String)response.readEntity(String.class);
        TokenRestWebServiceWithHSAlgEmbeddedTest.showResponse("requestAccessTokenWithClientSecretJwtHS512Step2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertTrue((response.getHeaderString("Cache-Control") != null && response.getHeaderString("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Cache-Control")));
        Assert.assertTrue((response.getHeaderString("Pragma") != null && response.getHeaderString("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeaderString("Pragma")));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
            Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
            Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage(), (Throwable)e);
        }
    }
}

