/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.client.AuthorizationRequest;
import org.gluu.oxauth.client.EndSessionRequest;
import org.gluu.oxauth.client.QueryStringDecoder;
import org.gluu.oxauth.client.RegisterRequest;
import org.gluu.oxauth.client.RegisterResponse;
import org.gluu.oxauth.model.common.Prompt;
import org.gluu.oxauth.model.common.ResponseType;
import org.gluu.oxauth.model.register.ApplicationType;
import org.gluu.oxauth.model.register.RegisterResponseParam;
import org.gluu.oxauth.model.util.StringUtils;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.ws.rs.ClientTestUtil;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class EndSessionRestWebServiceEmbeddedTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static String clientId;
    private static String idToken;
    private static String sid;

    @Parameters(value={"registerPath", "redirectUris", "postLogoutRedirectUri"})
    @Test
    public void requestEndSessionStep1(String registerPath, String redirectUris, String postLogoutRedirectUri) throws Exception {
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + registerPath).request();
        String registerRequestContent = null;
        try {
            RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
            registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
            registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
            registerRequest.setFrontChannelLogoutUris((List)Lists.newArrayList((Object[])new String[]{postLogoutRedirectUri}));
            registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
            registerRequestContent = ServerUtil.toPrettyJson((JSONObject)registerRequest.getJSONParameters());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Response response = request.post(Entity.json(registerRequestContent));
        String entity = (String)response.readEntity(String.class);
        EndSessionRestWebServiceEmbeddedTest.showResponse("requestEndSessionStep1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + entity));
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            RegisterResponse registerResponse = RegisterResponse.valueOf((String)entity);
            ClientTestUtil.assert_((RegisterResponse)registerResponse);
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            clientId = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestEndSessionStep1"})
    public void requestEndSessionStep2(String authorizePath, String userId, String userSecret, String redirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + authorizePath + "?" + authorizationRequest.getQueryString()).request();
        request.header("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
        request.header("Accept", (Object)"text/plain");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        EndSessionRestWebServiceEmbeddedTest.showResponse("requestEndSessionStep2", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)response.getLocation(), (String)("Unexpected result: " + response.getLocation()));
        if (response.getLocation() != null) {
            try {
                URI uri = new URI(response.getLocation().toString());
                Assert.assertNotNull((Object)uri.getFragment(), (String)"Fragment is null");
                Map params = QueryStringDecoder.decode((String)uri.getFragment());
                Assert.assertNotNull(params.get("access_token"), (String)"The access token is null");
                Assert.assertNotNull(params.get("state"), (String)"The state is null");
                Assert.assertNotNull(params.get("token_type"), (String)"The token type is null");
                Assert.assertNotNull(params.get("expires_in"), (String)"The expires in value is null");
                Assert.assertNotNull(params.get("scope"), (String)"The scope must be null");
                Assert.assertNull(params.get("refresh_token"), (String)"The refresh_token must be null");
                Assert.assertEquals((String)((String)params.get("state")), (String)state);
                idToken = (String)params.get("id_token");
                sid = (String)params.get("sid");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                Assert.fail((String)"Response URI is not well formed");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Parameters(value={"endSessionPath", "postLogoutRedirectUri"})
    @Test(dependsOnMethods={"requestEndSessionStep2"})
    public void requestEndSessionStep3(String endSessionPath, String postLogoutRedirectUri) throws Exception {
        String state = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest = new EndSessionRequest(idToken, postLogoutRedirectUri, state);
        endSessionRequest.setSid(sid);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + endSessionPath + "?" + endSessionRequest.getQueryString()).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        EndSessionRestWebServiceEmbeddedTest.showResponse("requestEndSessionStep3", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)"Unexpected html.");
        Assert.assertTrue((boolean)entity.contains(postLogoutRedirectUri));
        Assert.assertTrue((boolean)entity.contains(postLogoutRedirectUri));
    }

    @Parameters(value={"endSessionPath"})
    @Test(enabled=true)
    public void requestEndSessionFail1(String endSessionPath) throws Exception {
        EndSessionRequest endSessionRequest = new EndSessionRequest(null, null, null);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + endSessionPath + "?" + endSessionRequest.getQueryString()).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        EndSessionRestWebServiceEmbeddedTest.showResponse("requestEndSessionFail1", response, entity);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }

    @Parameters(value={"endSessionPath", "postLogoutRedirectUri"})
    @Test
    public void requestEndSessionFail2(String endSessionPath, String postLogoutRedirectUri) {
        String endSessionId = UUID.randomUUID().toString();
        EndSessionRequest endSessionRequest = new EndSessionRequest("INVALID_ACCESS_TOKEN", postLogoutRedirectUri, endSessionId);
        Invocation.Builder request = ResteasyClientBuilder.newClient().target(this.url.toString() + endSessionPath + "?" + endSessionRequest.getQueryString()).request();
        request.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        Response response = request.get();
        String entity = (String)response.readEntity(String.class);
        EndSessionRestWebServiceEmbeddedTest.showResponse("requestEndSessionFail2", response, entity);
        Assert.assertTrue((response.getStatus() == 400 || response.getStatus() == 307 ? 1 : 0) != 0, (String)"Unexpected response code.");
        Assert.assertNotNull((Object)entity, (String)("Unexpected result: " + entity));
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
            Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + entity));
        }
    }
}

