/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import java.net.URI;
import java.util.Arrays;
import org.gluu.oxauth.BaseTest;
import org.gluu.oxauth.model.uma.PermissionTicket;
import org.gluu.oxauth.model.uma.RPTResponse;
import org.gluu.oxauth.model.uma.RptIntrospectionResponse;
import org.gluu.oxauth.model.uma.TUma;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaResourceResponse;
import org.gluu.oxauth.model.uma.UmaTestUtil;
import org.gluu.oxauth.model.uma.wrapper.Token;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class AccessProtectedResourceFlowWSTest
extends BaseTest {
    @ArquillianResource
    private URI url;
    private static Token pat;
    private static RPTResponse rpt;
    private static UmaResourceResponse resource;
    private static PermissionTicket ticket;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init_0(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
        pat = TUma.requestPat(this.url, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)pat);
    }

    @Test(dependsOnMethods={"init_0"})
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init_1(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) {
    }

    @Test(dependsOnMethods={"init_1"})
    @Parameters(value={"umaRptPath"})
    public void init(String umaRptPath) {
        rpt = TUma.requestRpt(this.url, umaRptPath);
        UmaTestUtil.assert_((RPTResponse)rpt);
    }

    @Test(dependsOnMethods={"init"})
    @Parameters(value={"umaRegisterResourcePath"})
    public void _1_registerResource(String umaRegisterResourcePath) throws Exception {
        resource = TUma.registerResource(this.url, pat, umaRegisterResourcePath, UmaTestUtil.createResource());
        UmaTestUtil.assert_((UmaResourceResponse)resource);
    }

    @Test(dependsOnMethods={"_1_registerResource"})
    public void _2_requesterAccessProtectedResourceWithNotEnoughPermissionsRpt() throws Exception {
        AccessProtectedResourceFlowWSTest.showTitle("_2_requesterAccessProtectedResourceWithNotEnoughPermissionsRpt");
    }

    @Test(dependsOnMethods={"_2_requesterAccessProtectedResourceWithNotEnoughPermissionsRpt"})
    @Parameters(value={"umaRptStatusPath"})
    public void _3_hostDeterminesRptStatus(String umaRptStatusPath) throws Exception {
        RptIntrospectionResponse status = TUma.requestRptStatus(this.url, umaRptStatusPath, rpt.getRpt());
        Assert.assertTrue((boolean)status.getActive(), (String)"Token response status is not active");
        Assert.assertTrue((status.getPermissions() == null || status.getPermissions().isEmpty() ? 1 : 0) != 0, (String)"Permissions list is not empty.");
    }

    @Test(dependsOnMethods={"_3_hostDeterminesRptStatus"})
    @Parameters(value={"umaPermissionPath"})
    public void _4_registerPermissionForRpt(String umaPermissionPath) throws Exception {
        UmaPermission r = new UmaPermission();
        r.setResourceId(resource.getId());
        r.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view"));
        ticket = TUma.registerPermission(this.url, pat, r, umaPermissionPath);
        UmaTestUtil.assert_((PermissionTicket)ticket);
    }

    @Test(dependsOnMethods={"_4_registerPermissionForRpt"})
    @Parameters(value={"umaPermissionAuthorizationPath"})
    public void _5_authorizePermission(String umaPermissionAuthorizationPath) {
    }

    @Test(dependsOnMethods={"_5_authorizePermission"})
    @Parameters(value={"umaRptStatusPath"})
    public void _6_hostDeterminesRptStatus(String umaRptStatusPath) throws Exception {
        RptIntrospectionResponse status = TUma.requestRptStatus(this.url, umaRptStatusPath, rpt.getRpt());
        UmaTestUtil.assert_((RptIntrospectionResponse)status);
    }

    @Test(dependsOnMethods={"_6_hostDeterminesRptStatus"})
    public void _7_requesterAccessProtectedResourceWithEnoughPermissionsRpt() throws Exception {
        AccessProtectedResourceFlowWSTest.showTitle("_7_requesterAccessProtectedResourceWithEnoughPermissionsRpt");
    }

    @Test(dependsOnMethods={"_7_requesterAccessProtectedResourceWithEnoughPermissionsRpt"})
    @Parameters(value={"umaRegisterResourcePath"})
    public void cleanUp(String umaRegisterResourcePath) {
        if (resource != null) {
            TUma.deleteResource(this.url, pat, umaRegisterResourcePath, resource.getId());
        }
    }
}

