/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import org.gluu.saml.Response;
import org.gluu.saml.SamlConfiguration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class XmlSignatureTest {
    @Test
    public void checkSignatureOld() throws Exception {
        System.out.println(System.getProperties());
        String cert = "MIIDcDCCAlgCCQCweorgMjoVHzANBgkqhkiG9w0BAQUFADB6MQswCQYDVQQGEwJVUzELMAkGA1UE\r\nCAwCVFgxDzANBgNVBAcMBkF1c3RpbjESMBAGA1UECgwJR2x1dSBJbmMuMRswGQYDVQQDDBJhc2lt\r\nYmEzMTEuZ2x1dS5vcmcxHDAaBgkqhkiG9w0BCQEWDXppY29AZ2x1dS5vcmcwHhcNMjAxMjExMDUw\r\nNDQ4WhcNMjExMjExMDUwNDQ4WjB6MQswCQYDVQQGEwJVUzELMAkGA1UECAwCVFgxDzANBgNVBAcM\r\nBkF1c3RpbjESMBAGA1UECgwJR2x1dSBJbmMuMRswGQYDVQQDDBJhc2ltYmEzMTEuZ2x1dS5vcmcx\r\nHDAaBgkqhkiG9w0BCQEWDXppY29AZ2x1dS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\r\nAoIBAQDBGe69Xiy9Jeo6yg9FkkYWqeGFAgWwsNESima1WIjplM+CARiVS42wcqpEI6G79W2mKC8c\r\nyukTpAXTtGU68pArTIu72Abq55L5WTLxGQnr2/iYVWUrHPNTVVtjylsZA9gX/BvqqbWMS84q69T6\r\njVnjIoPBzMIeqq4LjmPJQ00s2AlHFahmt0d22o3NdoQeVBHZ79bsWKyagIF16/anvDr/j1+51Ttg\r\n+3k3IPbCLXPMKUgBwN/tIaOfj9A+pUYoqHKakuwzpErITrIJrJQzQmk8bEWJVkj6UasA7ZDCt+KV\r\nmGSJtDr71kgNDJIUhRT1YeH2NfnQ0MPenOej4repFkdVAgMBAAEwDQYJKoZIhvcNAQEFBQADggEB\r\nAKTIhyUQmVC9IcQfF/U7c6ZoF08xhnDb4RGOo7CC1BQ652ehqmC5hZrDbMZiG5TKdeFMCDPcU9NC\r\nJv6xybVTzbDxG4PCXSKBv+PneNEhJZiDtCr0CBub7+cw3ZGLBjriwVkRq7Wh/1ZlRB+vlBP0Si0j\r\nNmh67mDMsbeyubnttSU4S8HgiJYGHSHTQoM1ncXggy805jJn0JOyp1TFO0Cp7s7VRPb1PsrcfmfK\r\nqOTOCIaumckVsfz6EofPPdoYDA+c+J0nYXFxzsrdXscWJvW+flAWGpw2995hlmwpR1L92uM8O1km\r\ncOllnhfo6n0P3GfutOf2dEM2z65F0J249GTA0QA=";
        String response = "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";
        SamlConfiguration samlConfiguration = new SamlConfiguration();
        samlConfiguration.loadCertificateFromString(cert);
        Response resp = new Response(samlConfiguration);
        resp.loadXmlFromBase64(response);
        boolean result = resp.isValidNew();
        Assert.assertTrue((boolean)result, (String)"XML signature is invalid");
    }

    @Test
    public void checkSignatureNew() throws Exception {
        String cert = "MIIDcDCCAlgCCQCweorgMjoVHzANBgkqhkiG9w0BAQUFADB6MQswCQYDVQQGEwJVUzELMAkGA1UE\r\nCAwCVFgxDzANBgNVBAcMBkF1c3RpbjESMBAGA1UECgwJR2x1dSBJbmMuMRswGQYDVQQDDBJhc2lt\r\nYmEzMTEuZ2x1dS5vcmcxHDAaBgkqhkiG9w0BCQEWDXppY29AZ2x1dS5vcmcwHhcNMjAxMjExMDUw\r\nNDQ4WhcNMjExMjExMDUwNDQ4WjB6MQswCQYDVQQGEwJVUzELMAkGA1UECAwCVFgxDzANBgNVBAcM\r\nBkF1c3RpbjESMBAGA1UECgwJR2x1dSBJbmMuMRswGQYDVQQDDBJhc2ltYmEzMTEuZ2x1dS5vcmcx\r\nHDAaBgkqhkiG9w0BCQEWDXppY29AZ2x1dS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\r\nAoIBAQDBGe69Xiy9Jeo6yg9FkkYWqeGFAgWwsNESima1WIjplM+CARiVS42wcqpEI6G79W2mKC8c\r\nyukTpAXTtGU68pArTIu72Abq55L5WTLxGQnr2/iYVWUrHPNTVVtjylsZA9gX/BvqqbWMS84q69T6\r\njVnjIoPBzMIeqq4LjmPJQ00s2AlHFahmt0d22o3NdoQeVBHZ79bsWKyagIF16/anvDr/j1+51Ttg\r\n+3k3IPbCLXPMKUgBwN/tIaOfj9A+pUYoqHKakuwzpErITrIJrJQzQmk8bEWJVkj6UasA7ZDCt+KV\r\nmGSJtDr71kgNDJIUhRT1YeH2NfnQ0MPenOej4repFkdVAgMBAAEwDQYJKoZIhvcNAQEFBQADggEB\r\nAKTIhyUQmVC9IcQfF/U7c6ZoF08xhnDb4RGOo7CC1BQ652ehqmC5hZrDbMZiG5TKdeFMCDPcU9NC\r\nJv6xybVTzbDxG4PCXSKBv+PneNEhJZiDtCr0CBub7+cw3ZGLBjriwVkRq7Wh/1ZlRB+vlBP0Si0j\r\nNmh67mDMsbeyubnttSU4S8HgiJYGHSHTQoM1ncXggy805jJn0JOyp1TFO0Cp7s7VRPb1PsrcfmfK\r\nqOTOCIaumckVsfz6EofPPdoYDA+c+J0nYXFxzsrdXscWJvW+flAWGpw2995hlmwpR1L92uM8O1km\r\ncOllnhfo6n0P3GfutOf2dEM2z65F0J249GTA0QA=";
        String response = "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";
        SamlConfiguration samlConfiguration = new SamlConfiguration();
        samlConfiguration.loadCertificateFromString(cert);
        Response resp = new Response(samlConfiguration);
        resp.loadXmlFromBase64(response);
        boolean result = resp.isValid();
        Assert.assertTrue((boolean)result, (String)"XML signature is invalid");
    }
}

