/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.comp;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gluu.oxauth.BaseComponentTest;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.service.ClientService;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.util.StringHelper;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class CleanUpClientTest
extends BaseComponentTest {
    @Inject
    private ClientService clientService;

    @Test
    @Parameters(value={"usedClients"})
    public void cleanUpClient(String usedClients) {
        Assert.assertNotNull((Object)usedClients);
        List<String> usedClientsList = Arrays.asList(StringHelper.split((String)usedClients, (String)",", (boolean)true, (boolean)false));
        CleanUpClientTest.output("Used clients: " + usedClientsList);
        int clientsResultSetSize = 50;
        int countResults = 0;
        int countRemoved = 0;
        boolean existsMoreClients = true;
        while (existsMoreClients && countResults < 10000) {
            List clients = this.clientService.getAllClients(new String[]{"inum"}, clientsResultSetSize);
            existsMoreClients = clients.size() == clientsResultSetSize;
            Assert.assertNotNull((Object)clients);
            CleanUpClientTest.output("Found clients: " + clients.size());
            CleanUpClientTest.output("Total clients: " + (countResults += clients.size()));
            for (Client client : clients) {
                String clientId = client.getClientId();
                if (usedClientsList.contains(clientId)) continue;
                try {
                    this.clientService.remove(client);
                }
                catch (EntryPersistenceException ex) {
                    CleanUpClientTest.output("Failed to remove client: " + ex.getMessage());
                }
                ++countRemoved;
            }
        }
        CleanUpClientTest.output("Removed clients: " + countRemoved);
    }
}

