/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.ws.rs.stat;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.agkn.hll.HLL;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.model.stat.StatEntry;
import org.gluu.oxauth.model.token.TokenErrorResponseType;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.stat.StatService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.oxauth.ws.rs.stat.StatResponse;
import org.gluu.oxauth.ws.rs.stat.StatResponseItem;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/internal/stat")
public class StatWS {
    private static final int DEFAULT_WS_INTERVAL_LIMIT_IN_SECONDS = 60;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private Identity identity;
    @Inject
    private StatService statService;
    @Inject
    private AppConfiguration appConfiguration;
    private long lastProcessedAt;

    @GET
    @Produces(value={"application/json"})
    public Response statGet(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="month") String month) {
        return this.stat(month);
    }

    @POST
    @Produces(value={"application/json"})
    public Response statPost(@HeaderParam(value="Authorization") String authorization, @FormParam(value="month") String month) {
        return this.stat(month);
    }

    public Response stat(String month) {
        this.log.debug("Attempting to request stat, month: " + month);
        this.validateAuthorization();
        List<String> months = this.validateMonth(month);
        if (!this.allowToRun()) {
            this.log.trace("Interval request limit exceeded. Request is rejected. Current interval limit: " + this.appConfiguration.getStatWebServiceIntervalLimitInSeconds() + " (or 60 seconds if not set).");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.FORBIDDEN, (IErrorType)TokenErrorResponseType.ACCESS_DENIED, "Interval request limit exceeded.");
        }
        this.lastProcessedAt = System.currentTimeMillis();
        try {
            this.log.trace("Recognized months: " + months);
            String responseAsStr = ServerUtil.asJson(this.buildResponse(months));
            this.log.trace("Stat: " + responseAsStr);
            return Response.ok().entity((Object)responseAsStr).build();
        }
        catch (WebApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    private StatResponse buildResponse(List<String> months) {
        StatResponse response = new StatResponse();
        for (String month : months) {
            StatResponseItem responseItem = this.buildItem(month);
            if (responseItem == null) continue;
            response.getResponse().put(month, responseItem);
        }
        return response;
    }

    private StatResponseItem buildItem(String month) {
        try {
            String monthlyDn = String.format("ou=%s,%s", month, this.statService.getBaseDn());
            List entries = this.entryManager.findEntries(monthlyDn, StatEntry.class, Filter.createPresenceFilter((String)"jansId"));
            if (entries == null || entries.isEmpty()) {
                this.log.trace("Can't find stat entries for month: " + monthlyDn);
                return null;
            }
            StatResponseItem responseItem = new StatResponseItem();
            responseItem.setMonthlyActiveUsers(this.userCardinality(entries));
            this.unionTokenMapIntoResponseItem(entries, responseItem);
            return responseItem;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void unionTokenMapIntoResponseItem(List<StatEntry> entries, StatResponseItem responseItem) {
        for (StatEntry entry : entries) {
            for (Map.Entry en : entry.getStat().getTokenCountPerGrantType().entrySet()) {
                if (en.getValue() == null) continue;
                Map<String, Long> tokenMap = responseItem.getTokenCountPerGrantType().get(en.getKey());
                if (tokenMap == null) {
                    responseItem.getTokenCountPerGrantType().put((String)en.getKey(), (Map)en.getValue());
                    continue;
                }
                for (Map.Entry tokenEntry : ((Map)en.getValue()).entrySet()) {
                    Long counter = tokenMap.get(tokenEntry.getKey());
                    if (counter == null) {
                        tokenMap.put((String)tokenEntry.getKey(), (Long)tokenEntry.getValue());
                        continue;
                    }
                    tokenMap.put((String)tokenEntry.getKey(), counter + (Long)tokenEntry.getValue());
                }
            }
        }
    }

    private long userCardinality(List<StatEntry> entries) {
        StatEntry firstEntry = entries.get(0);
        HLL hll = HLL.fromBytes((byte[])firstEntry.getUserHllData().getBytes(StandardCharsets.UTF_8));
        if (entries.size() > 1) {
            for (int i = 1; i < entries.size(); ++i) {
                hll.union(HLL.fromBytes((byte[])entries.get(i).getUserHllData().getBytes(StandardCharsets.UTF_8)));
            }
        }
        return hll.cardinality();
    }

    private void validateAuthorization() {
        SessionClient sessionClient = this.identity.getSessionClient();
        if (sessionClient == null || sessionClient.getClient() == null) {
            this.log.trace("Client is not unknown. Skip stat processing.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.INVALID_CLIENT, "Failed to authenticate client.");
        }
    }

    private List<String> validateMonth(String month) {
        if (StringUtils.isBlank((String)month)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)TokenErrorResponseType.INVALID_REQUEST, "`month` parameter can't be blank and should be in format yyyyMM (e.g. 202012)");
        }
        month = ServerUtil.urlDecode(month);
        ArrayList<String> months = new ArrayList<String>();
        for (String m : month.split(" ")) {
            if ((m = m.trim()).length() != 6) continue;
            months.add(m);
        }
        if (months.isEmpty()) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)TokenErrorResponseType.INVALID_REQUEST, "`month` parameter can't be blank and should be in format yyyyMM (e.g. 202012)");
        }
        return months;
    }

    private boolean allowToRun() {
        int interval = this.appConfiguration.getStatWebServiceIntervalLimitInSeconds();
        if (interval <= 0) {
            interval = 60;
        }
        long timerInterval = interval * 1000;
        long timeDiff = System.currentTimeMillis() - this.lastProcessedAt;
        return timeDiff >= timerInterval;
    }
}

