/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.uma.ws.rs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.uma.PermissionTicket;
import org.gluu.oxauth.model.uma.UmaErrorResponseType;
import org.gluu.oxauth.model.uma.UmaPermission;
import org.gluu.oxauth.model.uma.UmaPermissionList;
import org.gluu.oxauth.service.token.TokenService;
import org.gluu.oxauth.uma.service.UmaPermissionService;
import org.gluu.oxauth.uma.service.UmaValidationService;
import org.gluu.oxauth.util.ServerUtil;
import org.slf4j.Logger;

@Path(value="/host/rsrc_pr")
public class UmaPermissionRegistrationWS {
    @Inject
    private Logger log;
    @Inject
    private TokenService tokenService;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private UmaValidationService umaValidationService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerPermission(@Context HttpServletRequest request, @HeaderParam(value="Authorization") String authorization, String requestAsString) {
        try {
            AuthorizationGrant authorizationGrant = this.umaValidationService.assertHasProtectionScope(authorization);
            UmaPermissionList permissionList = this.parseRequest(requestAsString);
            this.umaValidationService.validatePermissions(permissionList, authorizationGrant.getClient());
            String ticket = this.permissionService.addPermission(permissionList, this.tokenService.getClientDn(authorization));
            return Response.status((Response.Status)Response.Status.CREATED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new PermissionTicket(ticket)).build();
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error("Exception happened", (Throwable)ex);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }

    private UmaPermissionList parseRequest(String requestAsString) {
        ObjectMapper mapper = ServerUtil.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        try {
            UmaPermission permission = (UmaPermission)mapper.readValue(requestAsString, UmaPermission.class);
            return new UmaPermissionList().addPermission(permission);
        }
        catch (IOException permission) {
            try {
                UmaPermissionList permissions = (UmaPermissionList)mapper.readValue(requestAsString, UmaPermissionList.class);
                if (!permissions.isEmpty()) {
                    return permissions;
                }
                this.log.error("Permission list is empty.");
            }
            catch (IOException e) {
                this.log.error("Failed to parse uma permission request" + requestAsString, (Throwable)e);
            }
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)UmaErrorResponseType.INVALID_PERMISSION_REQUEST, "Failed to parse uma permission request.");
        }
    }
}

