/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.token.ws.rs;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.audit.ApplicationAuditLogger;
import org.gluu.oxauth.model.audit.Action;
import org.gluu.oxauth.model.audit.OAuth2AuditLog;
import org.gluu.oxauth.model.authorize.CodeVerifier;
import org.gluu.oxauth.model.common.AbstractAuthorizationGrant;
import org.gluu.oxauth.model.common.AccessToken;
import org.gluu.oxauth.model.common.AuthorizationCodeGrant;
import org.gluu.oxauth.model.common.AuthorizationGrant;
import org.gluu.oxauth.model.common.AuthorizationGrantList;
import org.gluu.oxauth.model.common.BackchannelTokenDeliveryMode;
import org.gluu.oxauth.model.common.CIBAGrant;
import org.gluu.oxauth.model.common.CibaRequestCacheControl;
import org.gluu.oxauth.model.common.CibaRequestStatus;
import org.gluu.oxauth.model.common.ClientCredentialsGrant;
import org.gluu.oxauth.model.common.DeviceAuthorizationCacheControl;
import org.gluu.oxauth.model.common.DeviceAuthorizationStatus;
import org.gluu.oxauth.model.common.DeviceCodeGrant;
import org.gluu.oxauth.model.common.ExecutionContext;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.common.IdToken;
import org.gluu.oxauth.model.common.RefreshToken;
import org.gluu.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.gluu.oxauth.model.common.SessionId;
import org.gluu.oxauth.model.common.TokenType;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.crypto.binding.TokenBindingMessage;
import org.gluu.oxauth.model.error.ErrorResponseFactory;
import org.gluu.oxauth.model.error.IErrorType;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.session.SessionClient;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwrService;
import org.gluu.oxauth.model.token.TokenErrorResponseType;
import org.gluu.oxauth.model.token.TokenParamsValidator;
import org.gluu.oxauth.security.Identity;
import org.gluu.oxauth.service.AttributeService;
import org.gluu.oxauth.service.AuthenticationFilterService;
import org.gluu.oxauth.service.AuthenticationService;
import org.gluu.oxauth.service.DeviceAuthorizationService;
import org.gluu.oxauth.service.GrantService;
import org.gluu.oxauth.service.SessionIdService;
import org.gluu.oxauth.service.UserService;
import org.gluu.oxauth.service.ciba.CibaRequestService;
import org.gluu.oxauth.service.external.ExternalResourceOwnerPasswordCredentialsService;
import org.gluu.oxauth.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import org.gluu.oxauth.token.ws.rs.TokenRestWebService;
import org.gluu.oxauth.uma.service.UmaTokenService;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.util.StringHelper;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class TokenRestWebServiceImpl
implements TokenRestWebService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private UserService userService;
    @Inject
    private GrantService grantService;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaTokenService umaTokenService;
    @Inject
    private ExternalResourceOwnerPasswordCredentialsService externalResourceOwnerPasswordCredentialsService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;

    @Override
    public Response requestAccessToken(String grantType, String code, String redirectUri, String username, String password, String scope, String assertion, String refreshToken, String clientId, String clientSecret, String codeVerifier, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, String authReqId, String deviceCode, HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        Response.ResponseBuilder builder;
        OAuth2AuditLog oAuth2AuditLog;
        block67: {
            this.log.debug("Attempting to request access token: grantType = {}, code = {}, redirectUri = {}, username = {}, refreshToken = {}, clientId = {}, ExtraParams = {}, isSecure = {}, codeVerifier = {}, ticket = {}", new Object[]{grantType, code, redirectUri, username, refreshToken, clientId, request.getParameterMap(), sec.isSecure(), codeVerifier, ticket});
            boolean isUma = StringUtils.isNotBlank((String)ticket);
            if (isUma) {
                return this.umaTokenService.requestRpt(grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope, request, response);
            }
            oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.TOKEN_REQUEST);
            oAuth2AuditLog.setClientId(clientId);
            oAuth2AuditLog.setUsername(username);
            oAuth2AuditLog.setScope(scope);
            String tokenBindingHeader = request.getHeader("Sec-Token-Binding");
            scope = ServerUtil.urlDecode(scope);
            builder = Response.ok();
            try {
                this.log.debug("Starting to validate request parameters");
                if (!TokenParamsValidator.validateParams(grantType, code, redirectUri, username, password, scope, assertion, refreshToken)) {
                    this.log.trace("Failed to validate request parameters");
                    return this.response(this.error(400, TokenErrorResponseType.INVALID_REQUEST, "Failed to validate request parameters"), oAuth2AuditLog);
                }
                GrantType gt = GrantType.fromString((String)grantType);
                this.log.debug("Grant type: '{}'", (Object)gt);
                SessionClient sessionClient = this.identity.getSessionClient();
                Client client = null;
                if (sessionClient != null) {
                    client = sessionClient.getClient();
                    this.log.debug("Get sessionClient: '{}'", (Object)sessionClient);
                }
                if (client == null) {
                    return this.response(this.error(401, TokenErrorResponseType.INVALID_GRANT, "Unable to find client."), oAuth2AuditLog);
                }
                this.log.debug("Get client from session: '{}'", (Object)client.getClientId());
                if (client.isDisabled()) {
                    return this.response(this.error(Response.Status.FORBIDDEN.getStatusCode(), TokenErrorResponseType.DISABLED_CLIENT, "Client is disabled."), oAuth2AuditLog);
                }
                Function idTokenTokingBindingPreprocessing = TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf());
                SessionId sessionIdObj = this.sessionIdService.getSessionId(request);
                Function<JsonWebResponse, Void> idTokenPreProcessing = JwrService.wrapWithSidFunction((Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing, sessionIdObj != null ? sessionIdObj.getOutsideSid() : null);
                if (gt == GrantType.AUTHORIZATION_CODE) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Grant types are invalid."), oAuth2AuditLog);
                    }
                    this.log.debug("Attempting to find authorizationCodeGrant by clientId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
                    AuthorizationCodeGrant authorizationCodeGrant = this.authorizationGrantList.getAuthorizationCodeGrant(code);
                    this.log.trace("AuthorizationCodeGrant : '{}'", (Object)authorizationCodeGrant);
                    if (authorizationCodeGrant == null) {
                        this.log.debug("AuthorizationCodeGrant is empty by clientId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
                        this.grantService.removeAllByAuthorizationCode(code);
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Unable to find grant object for given code."), oAuth2AuditLog);
                    }
                    if (!client.getClientId().equals(authorizationCodeGrant.getClientId())) {
                        this.log.debug("AuthorizationCodeGrant is found but belongs to another client. Grant's clientId: '{}', code: '{}'", (Object)authorizationCodeGrant.getClientId(), (Object)code);
                        this.grantService.removeAllByAuthorizationCode(code);
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Client mismatch."), oAuth2AuditLog);
                    }
                    this.validatePKCE(authorizationCodeGrant, codeVerifier, oAuth2AuditLog);
                    authorizationCodeGrant.setIsCachedWithNoPersistence(false);
                    authorizationCodeGrant.save();
                    RefreshToken reToken = null;
                    if (this.isRefreshTokenAllowed(client, scope, authorizationCodeGrant)) {
                        reToken = authorizationCodeGrant.createRefreshToken();
                    }
                    if (scope != null && !scope.isEmpty()) {
                        scope = authorizationCodeGrant.checkScopesPolicy(scope);
                    }
                    AccessToken accToken = authorizationCodeGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                    this.log.debug("Issuing access token: {}", (Object)accToken.getCode());
                    IdToken idToken = null;
                    if (authorizationCodeGrant.getScopes().contains("openid")) {
                        String nonce = authorizationCodeGrant.getNonce();
                        boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                        String idTokenTokenBindingCnf = client.getIdTokenTokenBindingCnf();
                        Function authorizationCodePreProcessing = jsonWebResponse -> {
                            if (StringUtils.isNotBlank((String)idTokenTokenBindingCnf) && StringUtils.isNotBlank((String)authorizationCodeGrant.getTokenBindingHash())) {
                                TokenBindingMessage.setCnfClaim((JsonWebResponse)jsonWebResponse, (String)authorizationCodeGrant.getTokenBindingHash(), (String)idTokenTokenBindingCnf);
                            }
                            return null;
                        };
                        idToken = authorizationCodeGrant.createIdToken(nonce, authorizationCodeGrant.getAuthorizationCode(), accToken, null, null, authorizationCodeGrant, includeIdTokenClaims, JwrService.wrapWithSidFunction((Function<JsonWebResponse, Void>)authorizationCodePreProcessing, sessionIdObj != null ? sessionIdObj.getOutsideSid() : null));
                    }
                    oAuth2AuditLog.updateOAuth2AuditLog(authorizationCodeGrant, true);
                    this.grantService.removeAuthorizationCode(authorizationCodeGrant.getAuthorizationCode().getCode());
                    String entity = this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken);
                    return this.response(Response.ok().entity((Object)entity), oAuth2AuditLog);
                }
                if (gt == GrantType.REFRESH_TOKEN) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "grant_type is not present in client."), oAuth2AuditLog);
                    }
                    AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), refreshToken);
                    if (authorizationGrant == null) {
                        this.log.trace("Grant object is not found by refresh token.");
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Unable to find grant object by refresh token or otherwise token type or client does not match."), oAuth2AuditLog);
                    }
                    RefreshToken refreshTokenObject = authorizationGrant.getRefreshToken(refreshToken);
                    if (refreshTokenObject == null || !refreshTokenObject.isValid()) {
                        this.log.trace("Invalid refresh token.");
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Unable to find refresh token or otherwise token type or client does not match."), oAuth2AuditLog);
                    }
                    RefreshToken reToken = null;
                    if (!this.appConfiguration.getSkipRefreshTokenDuringRefreshing().booleanValue()) {
                        reToken = this.appConfiguration.getRefreshTokenExtendLifetimeOnRotation() != false ? authorizationGrant.createRefreshToken() : authorizationGrant.createRefreshToken(refreshTokenObject.getExpirationDate());
                        this.grantService.removeByCode(refreshToken);
                    }
                    if (scope != null && !scope.isEmpty()) {
                        scope = authorizationGrant.checkScopesPolicy(scope);
                    }
                    AccessToken accToken = authorizationGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                    IdToken idToken = null;
                    if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && authorizationGrant.getScopes().contains("openid")) {
                        boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                        idToken = authorizationGrant.createIdToken(null, null, accToken, null, null, authorizationGrant, includeIdTokenClaims, idTokenPreProcessing);
                    }
                    builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                    oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, true);
                    break block67;
                }
                if (gt == GrantType.CLIENT_CREDENTIALS) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "grant_type is not present in client."), oAuth2AuditLog);
                    }
                    ClientCredentialsGrant clientCredentialsGrant = this.authorizationGrantList.createClientCredentialsGrant(new User(), client);
                    if (scope != null && !scope.isEmpty()) {
                        scope = clientCredentialsGrant.checkScopesPolicy(scope);
                    }
                    AccessToken accessToken = clientCredentialsGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                    IdToken idToken = null;
                    if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && clientCredentialsGrant.getScopes().contains("openid")) {
                        boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                        idToken = clientCredentialsGrant.createIdToken(null, null, null, null, null, clientCredentialsGrant, includeIdTokenClaims, idTokenPreProcessing);
                    }
                    oAuth2AuditLog.updateOAuth2AuditLog(clientCredentialsGrant, true);
                    builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), null, scope, idToken));
                    break block67;
                }
                if (gt == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
                    String userDn;
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "grant_type is not present in client."), oAuth2AuditLog);
                    }
                    boolean authenticated = false;
                    User user = null;
                    if (this.authenticationFilterService.isEnabled() && StringHelper.isNotEmpty((String)(userDn = this.authenticationFilterService.processAuthenticationFilters(request.getParameterMap())))) {
                        user = this.userService.getUserByDn(userDn, new String[0]);
                        authenticated = true;
                    }
                    if (!authenticated) {
                        if (this.externalResourceOwnerPasswordCredentialsService.isEnabled()) {
                            ExternalResourceOwnerPasswordCredentialsContext context = new ExternalResourceOwnerPasswordCredentialsContext(request, response, this.appConfiguration, this.attributeService, this.userService);
                            context.setUser(user);
                            if (this.externalResourceOwnerPasswordCredentialsService.executeExternalAuthenticate(context)) {
                                this.log.trace("RO PC - User is authenticated successfully by external script.");
                                user = context.getUser();
                            }
                        } else {
                            try {
                                authenticated = this.authenticationService.authenticate(username, password);
                                if (authenticated) {
                                    user = this.authenticationService.getAuthenticatedUser();
                                }
                            }
                            catch (AuthenticationException ex) {
                                this.log.trace("Failed to authenticate user ", (Throwable)new RuntimeException("User name or password is invalid"));
                            }
                        }
                    }
                    if (user != null) {
                        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = this.authorizationGrantList.createResourceOwnerPasswordCredentialsGrant(user, client);
                        SessionId sessionId = this.identity.getSessionId();
                        if (sessionId != null) {
                            resourceOwnerPasswordCredentialsGrant.setAcrValues("simple_password_auth");
                            resourceOwnerPasswordCredentialsGrant.setSessionDn(sessionId.getDn());
                            resourceOwnerPasswordCredentialsGrant.save();
                            sessionId.getSessionAttributes().put("authorized_grant", gt.getValue());
                            boolean updateResult = this.sessionIdService.updateSessionId(sessionId, false, true, true);
                            if (!updateResult) {
                                this.log.debug("Failed to update session entry: '{}'", (Object)sessionId.getId());
                            }
                        }
                        RefreshToken reToken = null;
                        if (this.isRefreshTokenAllowed(client, scope, resourceOwnerPasswordCredentialsGrant)) {
                            reToken = resourceOwnerPasswordCredentialsGrant.createRefreshToken();
                        }
                        if (scope != null && !scope.isEmpty()) {
                            scope = resourceOwnerPasswordCredentialsGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accessToken = resourceOwnerPasswordCredentialsGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                        IdToken idToken = null;
                        if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && resourceOwnerPasswordCredentialsGrant.getScopes().contains("openid")) {
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            idToken = resourceOwnerPasswordCredentialsGrant.createIdToken(null, null, null, null, null, resourceOwnerPasswordCredentialsGrant, includeIdTokenClaims, idTokenPreProcessing);
                        }
                        oAuth2AuditLog.updateOAuth2AuditLog(resourceOwnerPasswordCredentialsGrant, true);
                        builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken));
                    } else {
                        this.log.debug("Invalid user", (Throwable)new RuntimeException("User is empty"));
                        builder = this.error(401, TokenErrorResponseType.INVALID_CLIENT, "Invalid user.");
                    }
                    break block67;
                }
                if (gt == GrantType.CIBA) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Grant types are invalid."), oAuth2AuditLog);
                    }
                    this.log.debug("Attempting to find authorizationGrant by authReqId: '{}'", (Object)authReqId);
                    CIBAGrant cibaGrant = this.authorizationGrantList.getCIBAGrant(authReqId);
                    this.log.trace("AuthorizationGrant : '{}'", (Object)cibaGrant);
                    if (cibaGrant != null) {
                        if (!cibaGrant.getClientId().equals(client.getClientId())) {
                            builder = this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized.");
                            return this.response(builder, oAuth2AuditLog);
                        }
                        if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING || cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.POLL) {
                            if (!cibaGrant.isTokensDelivered()) {
                                RefreshToken refToken = cibaGrant.createRefreshToken();
                                this.log.debug("Issuing refresh token: {}", (Object)refToken.getCode());
                                AccessToken accessToken = cibaGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
                                this.log.debug("Issuing access token: {}", (Object)accessToken.getCode());
                                IdToken idToken = cibaGrant.createIdToken(null, null, accessToken, refToken, null, cibaGrant, false, null);
                                cibaGrant.setTokensDelivered(true);
                                cibaGrant.save();
                                RefreshToken reToken = null;
                                if (this.isRefreshTokenAllowed(client, scope, cibaGrant)) {
                                    reToken = refToken;
                                }
                                if (scope != null && !scope.isEmpty()) {
                                    scope = cibaGrant.checkScopesPolicy(scope);
                                }
                                builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken));
                                oAuth2AuditLog.updateOAuth2AuditLog(cibaGrant, true);
                            } else {
                                builder = this.error(400, TokenErrorResponseType.INVALID_GRANT, "AuthReqId is no longer available.");
                            }
                        } else {
                            this.log.debug("Client is not using Poll flow authReqId: '{}'", (Object)authReqId);
                            builder = this.error(400, TokenErrorResponseType.UNAUTHORIZED_CLIENT, "The client is not authorized as it is configured in Push Mode");
                        }
                    } else {
                        CibaRequestCacheControl cibaRequest = this.cibaRequestService.getCibaRequest(authReqId);
                        this.log.trace("Ciba request : '{}'", (Object)cibaRequest);
                        if (cibaRequest != null) {
                            if (!cibaRequest.getClient().getClientId().equals(client.getClientId())) {
                                builder = this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized.");
                                return this.response(builder, oAuth2AuditLog);
                            }
                            long currentTime = new Date().getTime();
                            Long lastAccess = cibaRequest.getLastAccessControl();
                            if (lastAccess == null) {
                                lastAccess = currentTime;
                            }
                            cibaRequest.setLastAccessControl(currentTime);
                            this.cibaRequestService.update(cibaRequest);
                            if (cibaRequest.getStatus() == CibaRequestStatus.PENDING) {
                                int intervalSeconds = this.appConfiguration.getBackchannelAuthenticationResponseInterval();
                                long timeFromLastAccess = currentTime - lastAccess;
                                if (timeFromLastAccess > (long)(intervalSeconds * 1000)) {
                                    this.log.debug("Access hasn't been granted yet for authReqId: '{}'", (Object)authReqId);
                                    builder = this.error(400, TokenErrorResponseType.AUTHORIZATION_PENDING, "User hasn't answered yet");
                                } else {
                                    this.log.debug("Slow down protection authReqId: '{}'", (Object)authReqId);
                                    builder = this.error(400, TokenErrorResponseType.SLOW_DOWN, "Client is asking too fast the token.");
                                }
                            } else if (cibaRequest.getStatus() == CibaRequestStatus.DENIED) {
                                this.log.debug("The end-user denied the authorization request for authReqId: '{}'", (Object)authReqId);
                                builder = this.error(400, TokenErrorResponseType.ACCESS_DENIED, "The end-user denied the authorization request.");
                            } else if (cibaRequest.getStatus() == CibaRequestStatus.EXPIRED) {
                                this.log.debug("The authentication request has expired for authReqId: '{}'", (Object)authReqId);
                                builder = this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "The authentication request has expired");
                            }
                        } else {
                            this.log.debug("AuthorizationGrant is empty by authReqId: '{}'", (Object)authReqId);
                            builder = this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "Unable to find grant object for given auth_req_id.");
                        }
                    }
                } else if (gt == GrantType.DEVICE_CODE) {
                    return this.processDeviceCodeGrantType(gt, client, deviceCode, scope, request, response, oAuth2AuditLog);
                }
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                builder = Response.status((int)500);
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.response(builder, oAuth2AuditLog);
    }

    private Response processDeviceCodeGrantType(GrantType grantType, Client client, String deviceCode, String scope, HttpServletRequest request, HttpServletResponse response, OAuth2AuditLog oAuth2AuditLog) {
        if (!TokenParamsValidator.validateGrantType(grantType, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
            return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Grant types are invalid."), oAuth2AuditLog);
        }
        this.log.debug("Attempting to find authorizationGrant by deviceCode: '{}'", (Object)deviceCode);
        DeviceCodeGrant deviceCodeGrant = this.authorizationGrantList.getDeviceCodeGrant(deviceCode);
        this.log.trace("DeviceCodeGrant : '{}'", (Object)deviceCodeGrant);
        if (deviceCodeGrant != null) {
            if (!deviceCodeGrant.getClientId().equals(client.getClientId())) {
                throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized."), oAuth2AuditLog));
            }
            RefreshToken refToken = deviceCodeGrant.createRefreshToken();
            this.log.debug("Issuing refresh token: {}", (Object)refToken.getCode());
            AccessToken accessToken = deviceCodeGrant.createAccessToken(request.getHeader("X-ClientCert"), new ExecutionContext(request, response));
            this.log.debug("Issuing access token: {}", (Object)accessToken.getCode());
            IdToken idToken = deviceCodeGrant.createIdToken(null, null, accessToken, refToken, null, deviceCodeGrant, false, null);
            RefreshToken reToken = null;
            if (this.isRefreshTokenAllowed(client, scope, deviceCodeGrant)) {
                reToken = refToken;
            }
            if (scope != null && !scope.isEmpty()) {
                scope = deviceCodeGrant.checkScopesPolicy(scope);
            }
            this.log.info("Device authorization in token endpoint processed and return to the client, device_code: {}", (Object)deviceCodeGrant.getDeviceCode());
            oAuth2AuditLog.updateOAuth2AuditLog(deviceCodeGrant, true);
            this.grantService.removeByCode(deviceCodeGrant.getDeviceCode());
            return Response.ok().entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken)).build();
        }
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByDeviceCode(deviceCode);
        this.log.trace("DeviceAuthorizationCacheControl data : '{}'", (Object)cacheData);
        if (cacheData == null) {
            this.log.debug("The authentication request has expired for deviceCode: '{}'", (Object)deviceCode);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "The authentication request has expired."), oAuth2AuditLog));
        }
        if (!cacheData.getClient().getClientId().equals(client.getClientId())) {
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized."), oAuth2AuditLog));
        }
        long currentTime = new Date().getTime();
        Long lastAccess = cacheData.getLastAccessControl();
        if (lastAccess == null) {
            lastAccess = currentTime;
        }
        cacheData.setLastAccessControl(currentTime);
        this.deviceAuthorizationService.saveInCache(cacheData, true, true);
        if (cacheData.getStatus() == DeviceAuthorizationStatus.PENDING) {
            int intervalSeconds = this.appConfiguration.getBackchannelAuthenticationResponseInterval();
            long timeFromLastAccess = currentTime - lastAccess;
            if (timeFromLastAccess > (long)(intervalSeconds * 1000)) {
                this.log.debug("Access hasn't been granted yet for deviceCode: '{}'", (Object)deviceCode);
                throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.AUTHORIZATION_PENDING, "User hasn't answered yet"), oAuth2AuditLog));
            }
            this.log.debug("Slow down protection deviceCode: '{}'", (Object)deviceCode);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.SLOW_DOWN, "Client is asking too fast the token."), oAuth2AuditLog));
        }
        if (cacheData.getStatus() == DeviceAuthorizationStatus.DENIED) {
            this.log.debug("The end-user denied the authorization request for deviceCode: '{}'", (Object)deviceCode);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.ACCESS_DENIED, "The end-user denied the authorization request."), oAuth2AuditLog));
        }
        this.log.debug("The authentication request has expired for deviceCode: '{}'", (Object)deviceCode);
        throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "The authentication request has expired"), oAuth2AuditLog));
    }

    private boolean isRefreshTokenAllowed(Client client, String requestedScope, AbstractAuthorizationGrant grant) {
        if (this.appConfiguration.getForceOfflineAccessScopeToEnableRefreshToken().booleanValue() && !grant.getScopes().contains("offline_access") && !Strings.nullToEmpty((String)requestedScope).contains("offline_access")) {
            return false;
        }
        return Arrays.asList(client.getGrantTypes()).contains(GrantType.REFRESH_TOKEN);
    }

    private void validatePKCE(AuthorizationCodeGrant grant, String codeVerifier, OAuth2AuditLog oAuth2AuditLog) {
        this.log.trace("PKCE validation, code_verifier: {}, code_challenge: {}, method: {}", new Object[]{codeVerifier, grant.getCodeChallenge(), grant.getCodeChallengeMethod()});
        if (Strings.isNullOrEmpty((String)grant.getCodeChallenge()) && Strings.isNullOrEmpty((String)codeVerifier)) {
            return;
        }
        if (!CodeVerifier.matched((String)grant.getCodeChallenge(), (String)grant.getCodeChallengeMethod(), (String)codeVerifier)) {
            this.log.error("PKCE check fails. Code challenge does not match to request code verifier, grantId:" + grant.getGrantId() + ", codeVerifier: " + codeVerifier);
            throw new WebApplicationException(this.response(this.error(401, TokenErrorResponseType.INVALID_GRANT, "PKCE check fails. Code challenge does not match to request code verifier."), oAuth2AuditLog));
        }
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private Response.ResponseBuilder error(int p_status, TokenErrorResponseType p_type, String reason) {
        return Response.status((int)p_status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)p_type, reason));
    }

    public String getJSonResponse(AccessToken accessToken, TokenType tokenType, Integer expiresIn, RefreshToken refreshToken, String scope, IdToken idToken) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("access_token", (Object)accessToken.getCode());
            jsonObj.put("token_type", (Object)tokenType.toString());
            if (expiresIn != null) {
                jsonObj.put("expires_in", (Object)expiresIn);
            }
            if (refreshToken != null) {
                jsonObj.put("refresh_token", (Object)refreshToken.getCode());
            }
            if (scope != null) {
                jsonObj.put("scope", (Object)scope);
            }
            if (idToken != null) {
                jsonObj.put("id_token", (Object)idToken.getCode());
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }
}

