/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.session.ws.rs;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.claims.Audience;
import org.gluu.oxauth.model.common.User;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.model.jwt.JwtClaims;
import org.gluu.oxauth.model.registration.Client;
import org.gluu.oxauth.model.token.JsonWebResponse;
import org.gluu.oxauth.model.token.JwrService;
import org.gluu.oxauth.service.SectorIdentifierService;
import org.json.JSONObject;
import org.msgpack.core.Preconditions;
import org.slf4j.Logger;

@Stateless
@Named
public class LogoutTokenFactory {
    private static final String EVENTS_KEY = "http://schemas.openid.net/event/backchannel-logout";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private JwrService jwrService;
    @Inject
    private SectorIdentifierService sectorIdentifierService;

    public JsonWebResponse createLogoutToken(Client rpClient, String outsideSid, User user) {
        try {
            Preconditions.checkNotNull((Object)rpClient);
            JsonWebResponse jwr = this.jwrService.createJwr(rpClient);
            this.fillClaims(jwr, rpClient, outsideSid, user);
            this.jwrService.encode(jwr, rpClient);
            return jwr;
        }
        catch (Exception e) {
            this.log.error("Failed to create logout_token for client:" + rpClient.getClientId());
            return null;
        }
    }

    private void fillClaims(JsonWebResponse jwr, Client client, String outsideSid, User user) {
        String sub;
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwr.getClaims().setExpirationTime(expiration);
        jwr.getClaims().setIssuedAt(issuedAt);
        jwr.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwr.getClaims().setJwtId(UUID.randomUUID());
        jwr.getClaims().setClaim("events", this.getLogoutTokenEvents());
        Audience.setAudience((JwtClaims)jwr.getClaims(), (Client)client);
        if (StringUtils.isNotBlank((String)outsideSid) && client.getAttributes().getBackchannelLogoutSessionRequired().booleanValue()) {
            jwr.getClaims().setClaim("sid", outsideSid);
        }
        if (StringUtils.isNotBlank((String)(sub = this.sectorIdentifierService.getSub(client, user, false)))) {
            jwr.getClaims().setSubjectIdentifier(sub);
        }
    }

    private JSONObject getLogoutTokenEvents() {
        JSONObject events = new JSONObject();
        events.put(EVENTS_KEY, (Object)new JSONObject());
        return events;
    }
}

