/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.GluuOrganization;
import org.gluu.oxauth.service.OrganizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/servlet/logo"})
public class OxAuthLogoServlet
extends HttpServlet {
    private static final long serialVersionUID = 5445488800130871634L;
    private static final Logger log = LoggerFactory.getLogger(OxAuthLogoServlet.class);
    public static final String BASE_OXAUTH_LOGO_PATH = "/opt/gluu/jetty/oxauth/custom/static/logo/";
    @Inject
    private OrganizationService organizationService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("/image/jpg");
        response.setDateHeader("Expires", new Date().getTime() + 1800000L);
        GluuOrganization organization = this.organizationService.getOrganization();
        boolean hasSucceed = this.readCustomLogo(response, organization);
        if (!hasSucceed) {
            this.readDefaultLogo(response);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readDefaultLogo(HttpServletResponse response) {
        String defaultLogoFileName = "/WEB-INF/static/logo.png";
        try (InputStream in = this.getServletContext().getResourceAsStream(defaultLogoFileName);){
            boolean bl;
            block14: {
                ServletOutputStream out = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    bl = true;
                    if (out == null) break block14;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return bl;
        }
        catch (IOException e) {
            log.debug("---------------Error loading default logo: " + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readCustomLogo(HttpServletResponse response, GluuOrganization organization) {
        File logoPath;
        if (organization.getOxAuthLogoPath() == null || StringUtils.isEmpty((String)organization.getOxAuthLogoPath())) {
            return false;
        }
        File directory = new File(BASE_OXAUTH_LOGO_PATH);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!(logoPath = new File(organization.getOxAuthLogoPath())).exists()) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(logoPath);){
            boolean bl;
            block16: {
                ServletOutputStream out = response.getOutputStream();
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    bl = true;
                    if (out == null) break block16;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return bl;
        }
        catch (IOException e) {
            log.debug("Error loading custom logo: " + e.getMessage());
            return false;
        }
    }
}

