/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.stat;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.configuration.AppConfiguration;
import org.gluu.oxauth.service.cdi.event.StatEvent;
import org.gluu.oxauth.service.stat.StatService;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class StatTimer {
    private static final int TIMER_TICK_INTERVAL_IN_SECONDS = 60;
    private static final int TIMER_INTERVAL_IN_SECONDS = 900;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StatService statService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    @Asynchronous
    public void initTimer() {
        this.log.info("Initializing Stat Service Timer");
        boolean initialized = this.statService.init();
        if (!initialized) {
            this.log.error("Failed to initialize Stat Service Timer.");
            return;
        }
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 60), (Object)new StatEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
        this.log.info("Initialized Stat Service Timer");
    }

    @Asynchronous
    public void process(@Observes @Scheduled StatEvent event) {
        if (!this.appConfiguration.getStatEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.allowToRun()) {
                return;
            }
            this.statService.updateStat();
            this.lastFinishedTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            this.log.error("Exception happened while updating stat", (Throwable)ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private boolean allowToRun() {
        int interval = this.appConfiguration.getStatTimerIntervalInSeconds();
        if (interval < 0) {
            this.log.info("Stat Timer is disabled.");
            this.log.warn("Stat Timer Interval (statTimerIntervalInSeconds in server configuration) is negative which turns OFF statistic on the server. Please set it to positive value if you wish it to run.");
            return false;
        }
        if (interval == 0) {
            interval = 900;
        }
        long timerInterval = interval * 1000;
        long timeDiff = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiff >= timerInterval;
    }
}

