/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.stat;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import net.agkn.hll.HLL;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxauth.model.common.GrantType;
import org.gluu.oxauth.model.config.Conf;
import org.gluu.oxauth.model.config.ConfigurationFactory;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.stat.Stat;
import org.gluu.oxauth.model.stat.StatEntry;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.base.SimpleBranch;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class StatService {
    private static final SimpleDateFormat PERIOD_DATE_FORMAT = new SimpleDateFormat("yyyyMM");
    private static final int regwidth = 5;
    private static final int log2m = 15;
    @Inject
    private Logger log;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private PersistenceEntryManager entryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    private String nodeId;
    private String monthlyDn;
    private StatEntry currentEntry;
    private HLL hll;
    private ConcurrentMap<String, Map<String, Long>> tokenCounters;

    public boolean init() {
        try {
            this.log.info("Initializing Stat Service");
            this.initNodeId();
            if (StringUtils.isBlank((String)this.nodeId)) {
                this.log.error("Failed to initialize stat service. statNodeId is not set in configuration.");
                return false;
            }
            if (StringUtils.isBlank((String)this.getBaseDn())) {
                this.log.error("Failed to initialize stat service. 'stat' base dn is not set in configuration.");
                return false;
            }
            Date now = new Date();
            this.prepareMonthlyBranch(now);
            if (StringUtils.isBlank((String)this.monthlyDn)) {
                this.log.error("Failed to initialize stat service. Failed to prepare monthly branch.");
                return false;
            }
            this.log.trace("Monthly branch created: " + this.monthlyDn);
            this.setupCurrentEntry(now);
            this.log.info("Initialized Stat Service");
            return true;
        }
        catch (Exception e) {
            this.log.error("Failed to initialize Stat Service.", (Throwable)e);
            return false;
        }
    }

    public void updateStat() {
        this.log.trace("Started updateStat ...");
        Date now = new Date();
        this.prepareMonthlyBranch(now);
        if (StringUtils.isBlank((String)this.monthlyDn)) {
            this.log.error("Failed to update stat. Unable to prepare monthly branch.");
            return;
        }
        this.setupCurrentEntry(now);
        Stat stat = this.currentEntry.getStat();
        stat.setTokenCountPerGrantType(this.tokenCounters);
        stat.setLastUpdatedAt(now.getTime());
        this.currentEntry.setUserHllData(new String(this.hll.toBytes(), StandardCharsets.UTF_8));
        this.entryManager.merge((Object)this.currentEntry);
        this.log.trace("Finished updateStat.");
    }

    private void setupCurrentEntry() {
        this.setupCurrentEntry(new Date());
    }

    private void setupCurrentEntry(Date now) {
        String month = PERIOD_DATE_FORMAT.format(now);
        String dn = String.format("jansId=%s,%s", this.nodeId, this.monthlyDn);
        if (this.currentEntry != null && month.equals(this.currentEntry.getStat().getMonth())) {
            return;
        }
        try {
            StatEntry entryFromPersistence = (StatEntry)this.entryManager.find(StatEntry.class, (Object)dn);
            if (entryFromPersistence != null && month.equals(entryFromPersistence.getStat().getMonth())) {
                this.hll = HLL.fromBytes((byte[])entryFromPersistence.getUserHllData().getBytes(StandardCharsets.UTF_8));
                this.tokenCounters = new ConcurrentHashMap<String, Map<String, Long>>(entryFromPersistence.getStat().getTokenCountPerGrantType());
                this.currentEntry = entryFromPersistence;
                this.log.trace("Stat entry loaded.");
                return;
            }
        }
        catch (EntryPersistenceException e) {
            this.log.trace("Stat entry is not found in persistence.");
        }
        if (this.currentEntry == null) {
            this.log.trace("Creating stat entry ...");
            this.hll = new HLL(15, 5);
            this.tokenCounters = new ConcurrentHashMap<String, Map<String, Long>>();
            this.currentEntry = new StatEntry();
            this.currentEntry.setId(this.nodeId);
            this.currentEntry.setDn(dn);
            this.currentEntry.setUserHllData(new String(this.hll.toBytes(), StandardCharsets.UTF_8));
            this.currentEntry.getStat().setMonth(PERIOD_DATE_FORMAT.format(new Date()));
            this.entryManager.persist((Object)this.currentEntry);
            this.log.trace("Created stat entry.");
        }
    }

    private void initNodeId() {
        if (StringUtils.isNotBlank((String)this.nodeId)) {
            return;
        }
        String dn = this.configurationFactory.getBaseConfiguration().getString("oxauth_ConfigurationEntryDN");
        Conf conf = (Conf)this.entryManager.find(Conf.class, (Object)dn);
        if (StringUtils.isNotBlank((String)conf.getDynamic().getStatNodeId())) {
            this.nodeId = conf.getDynamic().getStatNodeId();
            return;
        }
        try {
            this.nodeId = UUID.randomUUID().toString();
            conf.getDynamic().setStatNodeId(this.nodeId);
            conf.setRevision(conf.getRevision() + 1L);
            this.entryManager.merge((Object)conf);
            this.log.info("Updated statNodeId {} successfully", (Object)this.nodeId);
        }
        catch (Exception e) {
            this.nodeId = null;
            this.log.error("Failed to update statNodeId.", (Throwable)e);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getBaseDn() {
        return this.staticConfiguration.getBaseDn().getStat();
    }

    private void prepareMonthlyBranch(Date now) {
        String baseDn = this.getBaseDn();
        String month = PERIOD_DATE_FORMAT.format(now);
        this.monthlyDn = String.format("ou=%s,%s", month, baseDn);
        if (!this.entryManager.hasBranchesSupport(baseDn)) {
            return;
        }
        try {
            if (!this.entryManager.contains(this.monthlyDn, SimpleBranch.class)) {
                this.createBranch(this.monthlyDn, month);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to prepare monthly branch: " + this.monthlyDn, (Throwable)e);
            this.monthlyDn = null;
            throw e;
        }
    }

    public void createBranch(String branchDn, String ou) {
        block2: {
            try {
                SimpleBranch branch = new SimpleBranch();
                branch.setOrganizationalUnitName(ou);
                branch.setDn(branchDn);
                this.entryManager.persist((Object)branch);
            }
            catch (EntryPersistenceException ex) {
                if (this.entryManager.contains(branchDn, SimpleBranch.class)) break block2;
                throw ex;
            }
        }
    }

    public void reportActiveUser(String id) {
        if (StringUtils.isBlank((String)id)) {
            return;
        }
        this.setupCurrentEntry();
        this.hll.addRaw((long)id.hashCode());
    }

    public void reportAccessToken(GrantType grantType) {
        this.reportToken(grantType, "access_token");
    }

    public void reportIdToken(GrantType grantType) {
        this.reportToken(grantType, "id_token");
    }

    public void reportRefreshToken(GrantType grantType) {
        this.reportToken(grantType, "refresh_token");
    }

    public void reportUmaToken(GrantType grantType) {
        this.reportToken(grantType, "uma_token");
    }

    private void reportToken(GrantType grantType, String tokenKey) {
        if (grantType == null || tokenKey == null) {
            return;
        }
        if (this.tokenCounters == null) {
            this.log.error("Stat service is not initialized.");
            return;
        }
        Map tokenMap = this.tokenCounters.computeIfAbsent(grantType.getValue(), k -> new ConcurrentHashMap());
        Long counter = (Long)tokenMap.get(tokenKey);
        if (counter == null) {
            counter = 1L;
        } else {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        tokenMap.put(tokenKey, counter);
    }
}

