/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.fido.u2f;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.model.config.StaticConfiguration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistration;
import org.gluu.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.gluu.oxauth.model.util.Base64Util;
import org.gluu.oxauth.service.common.UserService;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@Stateless
@Named
public class DeviceRegistrationService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private UserService userService;
    @Inject
    private StaticConfiguration staticConfiguration;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("fido");
        branch.setDn(this.getBaseDnForU2fUserDevices(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(this.getBaseDnForU2fUserDevices(userInum), SimpleBranch.class);
    }

    public void prepareBranch(String userInum) {
        String baseDn = this.getBaseDnForU2fUserDevices(userInum);
        if (!this.ldapEntryManager.hasBranchesSupport(baseDn)) {
            return;
        }
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public DeviceRegistration findUserDeviceRegistration(String userInum, String deviceId, String ... returnAttributes) {
        this.prepareBranch(userInum);
        String deviceDn = this.getDnForU2fDevice(userInum, deviceId);
        return (DeviceRegistration)this.ldapEntryManager.find((Object)deviceDn, DeviceRegistration.class, returnAttributes);
    }

    public List<DeviceRegistration> findUserDeviceRegistrations(String userInum, String appId, String ... returnAttributes) {
        this.prepareBranch(userInum);
        String baseDnForU2fDevices = this.getBaseDnForU2fUserDevices(userInum);
        Filter userInumFilter = Filter.createEqualityFilter((String)"personInum", (Object)userInum);
        Filter appIdFilter = Filter.createEqualityFilter((String)"oxApplication", (Object)appId);
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{userInumFilter, appIdFilter});
        return this.ldapEntryManager.findEntries(baseDnForU2fDevices, DeviceRegistration.class, filter, returnAttributes);
    }

    public List<DeviceRegistration> findDeviceRegistrationsByKeyHandle(String appId, String keyHandle, String ... returnAttributes) {
        if (StringHelper.isEmpty((String)appId) || StringHelper.isEmpty((String)keyHandle)) {
            return new ArrayList<DeviceRegistration>(0);
        }
        byte[] keyHandleDecoded = Base64Util.base64urldecode((String)keyHandle);
        String baseDn = this.userService.getDnForUser(null);
        Filter deviceObjectClassFilter = Filter.createEqualityFilter((String)"objectClass", (Object)"oxDeviceRegistration");
        Filter deviceHashCodeFilter = Filter.createEqualityFilter((String)"oxDeviceHashCode", (Object)this.getKeyHandleHashCode(keyHandleDecoded));
        Filter deviceKeyHandleFilter = Filter.createEqualityFilter((String)"oxDeviceKeyHandle", (Object)keyHandle);
        Filter appIdFilter = Filter.createEqualityFilter((String)"oxApplication", (Object)appId);
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{deviceObjectClassFilter, deviceHashCodeFilter, appIdFilter, deviceKeyHandleFilter});
        return this.ldapEntryManager.findEntries(baseDn, DeviceRegistration.class, filter, returnAttributes);
    }

    public DeviceRegistration findOneStepUserDeviceRegistration(String deviceId, String ... returnAttributes) {
        String deviceDn = this.getDnForOneStepU2fDevice(deviceId);
        return (DeviceRegistration)this.ldapEntryManager.find(DeviceRegistration.class, (Object)deviceDn);
    }

    public void addUserDeviceRegistration(String userInum, DeviceRegistration deviceRegistration) {
        this.prepareBranch(userInum);
        deviceRegistration.clearExpiration();
        this.ldapEntryManager.persist((Object)deviceRegistration);
    }

    public boolean attachUserDeviceRegistration(String userInum, String oneStepDeviceId) {
        String oneStepDeviceDn = this.getDnForOneStepU2fDevice(oneStepDeviceId);
        DeviceRegistration deviceRegistration = (DeviceRegistration)this.ldapEntryManager.find(DeviceRegistration.class, (Object)oneStepDeviceDn);
        if (deviceRegistration == null) {
            return false;
        }
        this.removeUserDeviceRegistration(deviceRegistration);
        String deviceDn = this.getDnForU2fDevice(userInum, deviceRegistration.getId());
        deviceRegistration.setDn(deviceDn);
        deviceRegistration.clearExpiration();
        this.addUserDeviceRegistration(userInum, deviceRegistration);
        return true;
    }

    public void addOneStepDeviceRegistration(DeviceRegistration deviceRegistration) {
        deviceRegistration.setExpiration();
        this.ldapEntryManager.persist((Object)deviceRegistration);
    }

    public void updateDeviceRegistration(String userInum, DeviceRegistration deviceRegistration) {
        this.prepareBranch(userInum);
        this.ldapEntryManager.merge((Object)deviceRegistration);
    }

    public void disableUserDeviceRegistration(DeviceRegistration deviceRegistration) {
        deviceRegistration.setStatus(DeviceRegistrationStatus.COMPROMISED);
        this.ldapEntryManager.merge((Object)deviceRegistration);
    }

    public void removeUserDeviceRegistration(DeviceRegistration deviceRegistration) {
        this.ldapEntryManager.remove((Object)deviceRegistration);
    }

    public List<DeviceRegistration> getExpiredDeviceRegistrations(BatchOperation<DeviceRegistration> batchOperation, Date expirationDate, String[] returnAttributes, int sizeLimit, int chunkSize) {
        String u2fBaseDn = this.getDnForOneStepU2fDevice(null);
        Filter expirationFilter = Filter.createLessOrEqualFilter((String)"creationDate", (Object)this.ldapEntryManager.encodeTime(u2fBaseDn, expirationDate));
        List deviceRegistrations = this.ldapEntryManager.findEntries(u2fBaseDn, DeviceRegistration.class, expirationFilter, SearchScope.SUB, returnAttributes, batchOperation, 0, sizeLimit, chunkSize);
        return deviceRegistrations;
    }

    public int getCountDeviceRegistrations(String appId) {
        String baseDn = this.userService.getDnForUser(null);
        Filter appIdFilter = Filter.createEqualityFilter((String)"oxApplication", (Object)appId);
        Filter activeDeviceFilter = Filter.createEqualityFilter((String)"oxStatus", (Object)DeviceRegistrationStatus.ACTIVE.getValue());
        Filter resultFilter = Filter.createANDFilter((Filter[])new Filter[]{appIdFilter, activeDeviceFilter});
        return this.ldapEntryManager.countEntries(baseDn, DeviceRegistration.class, resultFilter);
    }

    public String getDnForU2fDevice(String userInum, String oxId) {
        String baseDnForU2fDevices = this.getBaseDnForU2fUserDevices(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDnForU2fDevices;
        }
        return String.format("oxId=%s,%s", oxId, baseDnForU2fDevices);
    }

    public String getBaseDnForU2fUserDevices(String userInum) {
        if (StringHelper.isEmpty((String)userInum)) {
            return this.getDnForOneStepU2fDevice("");
        }
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=fido,%s", userBaseDn);
    }

    public String getDnForOneStepU2fDevice(String deviceRegistrationId) {
        String u2fBaseDn = this.staticConfiguration.getBaseDn().getU2fBase();
        if (StringHelper.isEmpty((String)deviceRegistrationId)) {
            return String.format("ou=registered_devices,%s", u2fBaseDn);
        }
        return String.format("oxid=%s,ou=registered_devices,%s", deviceRegistrationId, u2fBaseDn);
    }

    public int getKeyHandleHashCode(byte[] keyHandle) {
        int hash = 0;
        for (int j = 0; j < keyHandle.length; ++j) {
            hash += keyHandle[j] * j;
        }
        return hash;
    }

    public void merge(DeviceRegistration device) {
        this.ldapEntryManager.merge((Object)device);
    }
}

