/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.net.util.SubnetUtils;
import org.gluu.oxauth.model.util.Util;
import org.gluu.oxauth.util.ServerUtil;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.base.CustomEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalScriptContext
extends org.gluu.service.external.context.ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(ExternalScriptContext.class);
    private final PersistenceEntryManager ldapEntryManager = ServerUtil.getLdapManager();

    public ExternalScriptContext(HttpServletRequest httpRequest) {
        this(httpRequest, null);
    }

    public ExternalScriptContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        super(httpRequest, httpResponse);
    }

    public PersistenceEntryManager getPersistenceEntryManager() {
        return this.ldapEntryManager;
    }

    public boolean isInNetwork(String cidrNotation) {
        String ip = this.getIpAddress();
        if (Util.allNotBlank((String[])new String[]{ip, cidrNotation})) {
            SubnetUtils utils = new SubnetUtils(cidrNotation);
            return utils.getInfo().isInRange(ip);
        }
        return false;
    }

    protected CustomEntry getEntryByDn(String dn, String ... ldapReturnAttributes) {
        try {
            return (CustomEntry)this.ldapEntryManager.find((Object)dn, CustomEntry.class, ldapReturnAttributes);
        }
        catch (EntryPersistenceException epe) {
            log.error("Failed to find entry '{}'", (Object)dn);
            return null;
        }
    }

    protected String getEntryAttributeValue(String dn, String attributeName) {
        CustomEntry entry = this.getEntryByDn(dn, attributeName);
        if (entry != null) {
            String attributeValue = entry.getCustomAttributeValue(attributeName);
            return attributeValue;
        }
        return "";
    }
}

