/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxauth.service.external;

import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.ciba.EndUserNotificationType;
import org.gluu.oxauth.service.external.context.ExternalCibaEndUserNotificationContext;
import org.gluu.service.custom.script.ExternalScriptService;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalCibaEndUserNotificationService
extends ExternalScriptService {
    private static final long serialVersionUID = -8609727759114795446L;
    @Inject
    private Logger log;

    public ExternalCibaEndUserNotificationService() {
        super(CustomScriptType.CIBA_END_USER_NOTIFICATION);
    }

    public boolean executeExternalNotifyEndUser(ExternalCibaEndUserNotificationContext context) {
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty()) {
            this.log.trace("There is no any external interception scripts defined.");
            return false;
        }
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (this.executeExternalNotifyEndUser(script, context)) continue;
            this.log.trace("Stopped running external interception scripts because script {} returns false.", (Object)script.getName());
            return false;
        }
        return true;
    }

    private boolean executeExternalNotifyEndUser(CustomScriptConfiguration customScriptConfiguration, ExternalCibaEndUserNotificationContext context) {
        try {
            this.log.trace("Executing external 'executeExternalNotifyEndUser' method, script name: {}, context: {}", (Object)customScriptConfiguration.getName(), (Object)context);
            EndUserNotificationType script = (EndUserNotificationType)customScriptConfiguration.getExternalType();
            boolean result = script.notifyEndUser((Object)context);
            this.log.trace("Finished external 'executeExternalNotifyEndUser' method, script name: {}, context: {}, result: {}", new Object[]{customScriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

